/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.redwoods.biomes;

import java.util.Random;
import mcp.MethodsReturnNonnullByDefault;
import net.coderbot.redwoods.block.BlockConiferSapling;
import net.coderbot.redwoods.init.ModBlocks;
import net.coderbot.redwoods.world.WorldGenConifer;
import net.coderbot.redwoods.world.WorldGenMegaConifer;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;

@MethodsReturnNonnullByDefault
public class BiomeConiferous
extends Biome {
    private WorldGenAbstractTree[] trees;
    private int fernPercentage;

    public BiomeConiferous(Properties properties) {
        super(properties.biomeProperties);
        this.field_76760_I.field_76832_z = properties.treesPerChunk;
        this.field_76760_I.field_76802_A = properties.flowerCount;
        this.field_76760_I.field_76803_B = properties.grassCount;
        this.field_76760_I.field_76798_D = 2;
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityWolf.class, 5, 4, 4));
        this.fernPercentage = properties.fernPercentage;
        this.trees = properties.getTrees();
        if (this.trees.length == 0) {
            this.field_76760_I.field_76832_z = 0;
        }
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        if (this.trees.length == 0) {
            return new WorldGenTrees(false);
        }
        if (this.trees.length == 1) {
            return this.trees[0];
        }
        return this.trees[rand.nextInt(this.trees.length)];
    }

    public WorldGenerator func_76730_b(Random rand) {
        int percent = rand.nextInt(100);
        if (percent < this.fernPercentage) {
            return new WorldGenTallGrass(BlockTallGrass.EnumType.FERN);
        }
        return new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    public static class Properties {
        public Biome.BiomeProperties biomeProperties;
        public boolean redwoodNormal;
        public boolean redwoodMega;
        public boolean firNormal;
        public boolean firMega;
        public int fernPercentage = 0;
        public int grassCount = 0;
        public int flowerCount = 0;
        public int treesPerChunk = 7;

        public Properties(String name, BiomeDictionary.Type ... types) {
            this.biomeProperties = new Biome.BiomeProperties(name);
        }

        WorldGenAbstractTree[] getTrees() {
            BlockConiferSapling.TreeDefinition tree;
            int enabled = 0;
            if (this.redwoodNormal) {
                ++enabled;
            }
            if (this.redwoodMega) {
                ++enabled;
            }
            if (this.firNormal) {
                ++enabled;
            }
            if (this.firMega) {
                ++enabled;
            }
            WorldGenAbstractTree[] trees = new WorldGenAbstractTree[enabled];
            enabled = 0;
            if (this.redwoodNormal) {
                tree = ModBlocks.REDWOOD;
                trees[enabled++] = new WorldGenConifer(false, tree.wood, tree.leaves);
            }
            if (this.redwoodMega) {
                tree = ModBlocks.REDWOOD;
                trees[enabled++] = new WorldGenMegaConifer(false, tree.woodSW, tree.woodNW, tree.woodNE, tree.woodSE, tree.leaves);
            }
            if (this.firNormal) {
                tree = ModBlocks.FIR;
                trees[enabled++] = new WorldGenConifer(false, tree.wood, tree.leaves);
            }
            if (this.firMega) {
                tree = ModBlocks.FIR;
                trees[enabled] = new WorldGenMegaConifer(false, tree.woodSW, tree.woodNW, tree.woodNE, tree.woodSE, tree.leaves);
            }
            return trees;
        }
    }
}

