/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.redwoods.block;

import java.util.BitSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.coderbot.redwoods.RedwoodsConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockConiferLeaves
extends BlockLeaves {
    private Item sapling;
    public static boolean allowLeavesDecay = true;

    public BlockConiferLeaves() {
        this.sapling = this.sapling;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
        this.func_149713_g(RedwoodsConfig.leavesDiffuseSkylight ? 1 : 0);
    }

    public void setSapling(Item sapling) {
        this.sapling = sapling;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false));
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i = 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        if (!((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue() || !((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            return;
        }
        if (DecayAlgorithm.canStay(world, pos)) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)));
        } else {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a});
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.SPRUCE;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.sapling;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.func_188055_a((Block)this));
            BlockConiferLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public NonNullList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState state;
        if (RedwoodsConfig.opaqueFaceLeafCulling && ((state = blockAccess.func_180495_p(pos.func_177972_a(side))).func_185914_p() || state.doesSideBlockRendering(blockAccess, pos, side))) {
            return false;
        }
        if (!Minecraft.func_71410_x().field_71474_y.field_74347_j || RedwoodsConfig.useOptiLeaves) {
            return !(blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() instanceof BlockConiferLeaves);
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!allowLeavesDecay) {
            return;
        }
        if (worldIn.func_175707_a(pos.func_177982_a(-5, -5, -5), pos.func_177982_a(5, 5, 5))) {
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-4, -4, -4), (BlockPos)pos.func_177982_a(4, 4, 4))) {
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, blockpos)) continue;
                iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
            }
        }
    }

    private static class DecayAlgorithm {
        private static final int FIELD_SIZE = 32;
        private static final int CENTER_OFFSET = 16;
        private static final byte MARKER_LEAVES = -1;
        private static final byte MARKER_IGNORE = -2;
        private static final int SCAN_RADIUS = 8;
        private static final int ITERATIONS = 13;
        private static final byte[] CELLS = new byte[32768];
        private static BitSet fillingQueue = new BitSet(CELLS.length);
        private static BitSet drainingQueue = new BitSet(CELLS.length);

        private DecayAlgorithm() {
        }

        private static int at(int dX, int dY, int dZ) {
            int aX = dX + 16;
            int aY = dY + 16;
            int aZ = dZ + 16;
            return aY * 32 * 32 + aZ * 32 + aX;
        }

        private static int atX(int index) {
            return index % 32 - 16;
        }

        private static int atZ(int index) {
            return index / 32 % 32 - 16;
        }

        private static int atY(int index) {
            return index / 32 / 32 - 16;
        }

        private static void markNeighbors(int dX, int dY, int dZ, BitSet queue) {
            queue.set(DecayAlgorithm.at(dX + 1, dY, dZ));
            queue.set(DecayAlgorithm.at(dX - 1, dY, dZ));
            queue.set(DecayAlgorithm.at(dX, dY + 1, dZ));
            queue.set(DecayAlgorithm.at(dX, dY - 1, dZ));
            queue.set(DecayAlgorithm.at(dX, dY, dZ + 1));
            queue.set(DecayAlgorithm.at(dX, dY, dZ - 1));
        }

        private static byte maximumNeighbor(int dX, int dY, int dZ) {
            return (byte)Math.max(Math.max(Math.max(CELLS[DecayAlgorithm.at(dX + 1, dY, dZ)], CELLS[DecayAlgorithm.at(dX - 1, dY, dZ)]), Math.max(CELLS[DecayAlgorithm.at(dX, dY + 1, dZ)], CELLS[DecayAlgorithm.at(dX, dY - 1, dZ)])), Math.max(CELLS[DecayAlgorithm.at(dX, dY, dZ + 1)], CELLS[DecayAlgorithm.at(dX, dY, dZ - 1)]));
        }

        static boolean canStay(World world, BlockPos origin) {
            int dX;
            if (!world.func_175697_a(origin, 10)) {
                return true;
            }
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            fillingQueue.clear();
            drainingQueue.clear();
            for (int dY = -8; dY <= 8; ++dY) {
                for (int dZ = -8; dZ <= 8; ++dZ) {
                    for (dX = -8; dX <= 8; ++dX) {
                        int light;
                        pos.func_181079_c(origin.func_177958_n() + dX, origin.func_177956_o() + dY, origin.func_177952_p() + dZ);
                        IBlockState state = world.func_180495_p((BlockPos)pos);
                        Block block = state.func_177230_c();
                        if (block.canSustainLeaves(state, (IBlockAccess)world, (BlockPos)pos)) {
                            light = 13;
                            DecayAlgorithm.markNeighbors(dX, dY, dZ, fillingQueue);
                        } else {
                            light = block.isLeaves(state, (IBlockAccess)world, (BlockPos)pos) ? -1 : -2;
                        }
                        DecayAlgorithm.CELLS[DecayAlgorithm.at((int)dX, (int)dY, (int)dZ)] = light;
                    }
                }
            }
            for (int distance = 1; distance <= 13; distance = (int)((byte)(distance + 1))) {
                BitSet temp = drainingQueue;
                drainingQueue = fillingQueue;
                fillingQueue = temp;
                int drainIndex = 0;
                while (!drainingQueue.isEmpty()) {
                    int dZ;
                    int dY;
                    int potentialValue;
                    drainIndex = drainingQueue.nextSetBit(drainIndex);
                    drainingQueue.clear(drainIndex);
                    if (CELLS[drainIndex] != -1 || (potentialValue = DecayAlgorithm.maximumNeighbor(dX = DecayAlgorithm.atX(drainIndex), dY = DecayAlgorithm.atY(drainIndex), dZ = DecayAlgorithm.atZ(drainIndex)) - 1) < 0) continue;
                    DecayAlgorithm.CELLS[drainIndex] = (byte)potentialValue;
                    DecayAlgorithm.markNeighbors(dX, dY, dZ, fillingQueue);
                }
            }
            return CELLS[DecayAlgorithm.at(0, 0, 0)] >= 0;
        }
    }
}

