/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.util;

import com.mrcrayfish.furniture.entity.EntitySeat;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class SeatUtil {
    public static boolean sitOnBlock(World world, double x, double y, double z, EntityPlayer player, double yOffset) {
        if (!(world.field_72995_K || player.func_70093_af() || SeatUtil.checkForExistingSeat(world, x, y, z, player))) {
            EntitySeat seat = new EntitySeat(world, x, y, z, yOffset);
            world.func_72838_d((Entity)seat);
            player.func_184220_m((Entity)seat);
        }
        return true;
    }

    public static boolean sitOnBlockWithRotationOffset(World world, double x, double y, double z, EntityPlayer player, double yOffset, int metadata, double rotationOffset) {
        if (!(world.field_72995_K || player.func_70093_af() || SeatUtil.checkForExistingSeat(world, x, y, z, player))) {
            EntitySeat seat = new EntitySeat(world, x, y, z, yOffset, metadata, rotationOffset);
            world.func_72838_d((Entity)seat);
            player.func_184220_m((Entity)seat);
        }
        return true;
    }

    private static boolean checkForExistingSeat(World world, double x, double y, double z, EntityPlayer player) {
        if (!world.field_72995_K) {
            List seats = world.func_72872_a(EntitySeat.class, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_186662_g(1.0));
            for (EntitySeat seat : seats) {
                if ((double)seat.blockPosX != x || (double)seat.blockPosY != y || (double)seat.blockPosZ != z) continue;
                if (!seat.func_184207_aI()) {
                    player.func_184220_m((Entity)seat);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isSomeoneSitting(World world, double x, double y, double z) {
        if (!world.field_72995_K) {
            List seats = world.func_72872_a(EntitySeat.class, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_186662_g(1.0));
            for (EntitySeat seat : seats) {
                if ((double)seat.blockPosX != x || (double)seat.blockPosY != y || (double)seat.blockPosZ != z) continue;
                return seat.func_184207_aI();
            }
        }
        return false;
    }
}

