/*
 * Decompiled with CFR 0.152.
 */
package lumien.custommainmenu.util;

import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;

public class MathUtil {
    public static boolean isPointInQuad(Vector2f pointP, Vector2f pointA, Vector2f pointB, Vector2f pointC, Vector2f pointD) {
        float rectArea;
        float pba;
        float cpb;
        float dpc;
        float apd = MathUtil.getTriangleArea(pointA, pointP, pointD);
        float sum = apd + (dpc = MathUtil.getTriangleArea(pointD, pointP, pointC)) + (cpb = MathUtil.getTriangleArea(pointC, pointP, pointB)) + (pba = MathUtil.getTriangleArea(pointP, pointB, pointA));
        return !(sum > (rectArea = MathUtil.getQuadArea(pointA, pointB, pointC)));
    }

    public static float getQuadArea(Vector2f pointA, Vector2f pointB, Vector2f pointC) {
        Vector2f abVec = (Vector2f)pointB.clone();
        abVec.sub((Tuple2f)pointA);
        float ab = abVec.length();
        Vector2f bcVec = (Vector2f)pointC.clone();
        bcVec.sub((Tuple2f)pointB);
        float bc = bcVec.length();
        return ab * bc;
    }

    public static float getTriangleArea(Vector2f pointA, Vector2f pointB, Vector2f pointC) {
        Vector2f ab = (Vector2f)pointB.clone();
        ab.sub((Tuple2f)pointA);
        float a = ab.length();
        Vector2f bc = (Vector2f)pointC.clone();
        bc.sub((Tuple2f)pointB);
        float b = bc.length();
        Vector2f ca = (Vector2f)pointA.clone();
        ca.sub((Tuple2f)pointC);
        float c = ca.length();
        float s = (a + b + c) / 2.0f;
        return (float)Math.sqrt(s * (s - a) * (s - b) * (s - c));
    }
}

