/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.nether.block.shrooms;

import com.progwml6.natura.nether.NaturaNether;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockNetherLargeGlowshroom
extends Block {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private final Block smallState;
    private final int glowshroomMeta;

    public BlockNetherLargeGlowshroom(Block smallStateIn, int glowshroomMetaIn) {
        super(Material.field_151575_d);
        this.func_149715_a(0.625f);
        this.smallState = smallStateIn;
        this.glowshroomMeta = glowshroomMetaIn;
    }

    public int func_149745_a(Random random) {
        return Math.max(0, random.nextInt(10) - 7);
    }

    public int func_180651_a(IBlockState state) {
        return this.glowshroomMeta;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.smallState);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this.smallState), 1, this.glowshroomMeta);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    protected boolean func_149700_E() {
        return true;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, 0);
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        Block block = blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c();
        if (block == NaturaNether.netherLargeBlueGlowshroom || block == NaturaNether.netherLargePurpleGlowshroom) {
            return false;
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockNetherLargeGlowshroom) {
            return null;
        }
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.9375, (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 1.0);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn.field_70181_x < 0.0) {
            entityIn.field_70181_x *= 0.25;
        }
        entityIn.field_70143_R -= 0.25f;
        if (entityIn.field_70181_x == 0.0) {
            entityIn.field_70159_w *= 0.25;
            entityIn.field_70179_y *= 0.25;
        }
        if (entityIn instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entityIn;
            living.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100, 0));
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        NORTH_WEST(1, "north_west"),
        NORTH(2, "north"),
        NORTH_EAST(3, "north_east"),
        WEST(4, "west"),
        CENTER(5, "center"),
        EAST(6, "east"),
        SOUTH_WEST(7, "south_west"),
        SOUTH(8, "south"),
        SOUTH_EAST(9, "south_east"),
        STEM(10, "stem"),
        ALL_INSIDE(0, "all_inside"),
        ALL_OUTSIDE(14, "all_outside"),
        ALL_STEM(15, "all_stem");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            EnumType enumtype;
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return (enumtype = META_LOOKUP[meta]) == null ? META_LOOKUP[0] : enumtype;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[16];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType enumtype;
                EnumType.META_LOOKUP[enumtype.getMeta()] = enumtype = enumTypeArray[i];
            }
        }
    }
}

