/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.bspkrscore.fml.bspkrsCoreMod;
import bspkrs.treecapitator.CommonProxy;
import bspkrs.treecapitator.config.TCConfigHandler;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.forge.ForgeEventHandler;
import bspkrs.treecapitator.registry.ModConfigRegistry;
import bspkrs.treecapitator.registry.RegistryNBTManager;
import bspkrs.treecapitator.registry.ThirdPartyModConfig;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.CommonUtils;
import bspkrs.util.ModVersionChecker;
import java.io.File;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="treecapitator", name="TreeCapitator", version="1.43.0", dependencies="required-after:bspkrsCore@[7.6.0.1,)", useMetadata=true, guiFactory="bspkrs.treecapitator.fml.gui.ModGuiFactoryHandler", acceptedMinecraftVersions="[1.12]")
public class TreecapitatorMod {
    protected ModVersionChecker versionChecker;
    protected final String versionURL = "http://bspk.rs/Minecraft/1.12/TreeCapitator.version";
    protected final String mcfTopic = "http://www.minecraftforum.net/topic/1009577-";
    private RegistryNBTManager nbtManager;
    @Mod.Metadata(value="treecapitator")
    public static ModMetadata metadata;
    @Mod.Instance(value="treecapitator")
    public static TreecapitatorMod instance;
    @SidedProxy(clientSide="bspkrs.treecapitator.ClientProxy", serverSide="bspkrs.treecapitator.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        metadata = event.getModMetadata();
        File file = event.getSuggestedConfigurationFile();
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        TCConfigHandler.setInstance(file);
        if (!CommonUtils.isObfuscatedEnv()) {
            TCSettings.allowDebugLogging = true;
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new ForgeEventHandler());
        FMLCommonHandler.instance().bus().register((Object)TCConfigHandler.instance());
        proxy.init(event);
        if (bspkrsCoreMod.instance.allowUpdateCheck) {
            this.versionChecker = new ModVersionChecker(TreecapitatorMod.metadata.name, TreecapitatorMod.metadata.version, "http://bspk.rs/Minecraft/1.12/TreeCapitator.version", "http://www.minecraftforum.net/topic/1009577-");
            this.versionChecker.checkVersionWithLogging();
        }
    }

    @Mod.EventHandler
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages().asList()) {
            if (msg.isNBTMessage() && msg.key.equals("EyeNotification")) continue;
            if (msg.isNBTMessage()) {
                TCLog.info("Received IMC message from mod %s.", msg.getSender());
                if (ThirdPartyModConfig.isValidNBT(msg.getNBTValue())) {
                    ModConfigRegistry.instance().registerIMCModConfig(msg.getSender(), ThirdPartyModConfig.readFromNBT(msg.getNBTValue()));
                    continue;
                }
                TCLog.severe("Validation failed for IMC message sent by %s", msg.getSender());
                continue;
            }
            TCLog.warning("Mod %s sent an IMC message, but it is not an NBT object message. The message will be ignored.", msg.getSender());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModConfigRegistry.instance().applyPrioritizedModConfigs();
        this.nbtManager();
    }

    public RegistryNBTManager nbtManager() {
        if (this.nbtManager == null) {
            this.nbtManager = new RegistryNBTManager();
        }
        return this.nbtManager;
    }
}

