/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiSawmill;
import cofh.thermalexpansion.gui.container.machine.ContainerSawmill;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TESounds;
import cofh.thermalexpansion.util.managers.device.TapperManager;
import cofh.thermalexpansion.util.managers.machine.SawmillManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileSawmill
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.SAWMILL.getMetadata();
    public static int basePower = 20;
    public static final int TAPPER_ENERGY_MOD = 50;
    private SawmillManager.SawmillRecipe curRecipe;
    private int inputTracker;
    private int outputTrackerPrimary;
    private int outputTrackerSecondary;
    private int outputTrackerFluid;
    private FluidTankCore tank = new FluidTankCore(4000);
    private FluidStack renderFluid = new FluidStack(TFFluids.fluidResin, 0);
    protected boolean augmentTapper;
    protected boolean flagTapper;

    public static void initialize() {
        TileSawmill.SIDE_CONFIGS[TileSawmill.TYPE] = new SideConfig();
        TileSawmill.SIDE_CONFIGS[TileSawmill.TYPE].numConfig = 7;
        TileSawmill.SIDE_CONFIGS[TileSawmill.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {2}, {1, 2}, {0, 1, 2}, {0, 1, 2}};
        TileSawmill.SIDE_CONFIGS[TileSawmill.TYPE].sideTypes = new int[]{0, 1, 2, 3, 4, 7, 8};
        TileSawmill.SIDE_CONFIGS[TileSawmill.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TileSawmill.ALT_SIDE_CONFIGS[TileSawmill.TYPE] = new SideConfig();
        TileSawmill.ALT_SIDE_CONFIGS[TileSawmill.TYPE].numConfig = 2;
        TileSawmill.ALT_SIDE_CONFIGS[TileSawmill.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {2}, {1, 2}, {0, 1, 2}, {0, 1, 2}};
        TileSawmill.ALT_SIDE_CONFIGS[TileSawmill.TYPE].sideTypes = new int[]{0, 7};
        TileSawmill.ALT_SIDE_CONFIGS[TileSawmill.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileSawmill.SLOT_CONFIGS[TileSawmill.TYPE] = new SlotConfig();
        TileSawmill.SLOT_CONFIGS[TileSawmill.TYPE].allowInsertionSlot = new boolean[]{true, false, false, false};
        TileSawmill.SLOT_CONFIGS[TileSawmill.TYPE].allowExtractionSlot = new boolean[]{false, true, true, false};
        TileSawmill.VALID_AUGMENTS[TileSawmill.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineSawmillTapper");
        VALID_AUGMENTS[TYPE].add("machineSecondary");
        VALID_AUGMENTS[TYPE].add("machineSecondaryNull");
        GameRegistry.registerTileEntity(TileSawmill.class, (String)"thermalexpansion:machine_sawmill");
        TileSawmill.config();
    }

    public static void config() {
        String category = "Machine.Sawmill";
        BlockMachine.enable[TileSawmill.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Sawmill. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 5000, comment);
        TileSawmill.ENERGY_CONFIGS[TileSawmill.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileSawmill() {
        this.inventory = new ItemStack[4];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        this.getRecipe();
        if (this.curRecipe == null) {
            return false;
        }
        if (this.inventory[0].func_190916_E() < this.curRecipe.getInput().func_190916_E()) {
            return false;
        }
        ItemStack primaryItem = this.curRecipe.getPrimaryOutput();
        ItemStack secondaryItem = this.curRecipe.getSecondaryOutput();
        if (!(secondaryItem.func_190926_b() || this.inventory[2].func_190926_b() || this.augmentSecondaryNull)) {
            if (!ItemHelper.itemsIdentical((ItemStack)this.inventory[2], (ItemStack)secondaryItem)) {
                return false;
            }
            if (this.inventory[2].func_190916_E() + secondaryItem.func_190916_E() > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        return this.inventory[1].func_190926_b() || ItemHelper.itemsIdentical((ItemStack)this.inventory[1], (ItemStack)primaryItem) && this.inventory[1].func_190916_E() + primaryItem.func_190916_E() <= primaryItem.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            return false;
        }
        return this.curRecipe.getInput().func_190916_E() <= this.inventory[0].func_190916_E();
    }

    @Override
    protected void clearRecipe() {
        this.curRecipe = null;
    }

    @Override
    protected void getRecipe() {
        this.curRecipe = SawmillManager.getRecipe(this.inventory[0]);
    }

    @Override
    protected void processStart() {
        if (this.augmentTapper && TapperManager.mappingExists(this.inventory[0])) {
            this.renderFluid = new FluidStack(TapperManager.getFluid(this.inventory[0]).copy(), 0);
        }
        this.processRem = this.processMax = this.curRecipe.getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            this.processOff();
            return;
        }
        ItemStack primaryItem = this.curRecipe.getPrimaryOutput();
        ItemStack secondaryItem = this.curRecipe.getSecondaryOutput();
        if (this.inventory[1].func_190926_b()) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)primaryItem);
        } else {
            this.inventory[1].func_190917_f(primaryItem.func_190916_E());
        }
        if (!secondaryItem.func_190926_b()) {
            int modifiedChance = this.secondaryChance;
            int recipeChance = this.curRecipe.getSecondaryOutputChance();
            if (recipeChance >= 100 || this.field_145850_b.field_73012_v.nextInt(modifiedChance) < recipeChance) {
                if (this.inventory[2].func_190926_b()) {
                    this.inventory[2] = ItemHelper.cloneStack((ItemStack)secondaryItem);
                } else if (this.inventory[2].func_77969_a(secondaryItem)) {
                    this.inventory[2].func_190917_f(secondaryItem.func_190916_E());
                }
                if (recipeChance > modifiedChance && this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                    this.inventory[2].func_190917_f(secondaryItem.func_190916_E());
                }
                if (this.inventory[2].func_190916_E() > this.inventory[2].func_77976_d()) {
                    this.inventory[2].func_190920_e(this.inventory[2].func_77976_d());
                }
            }
        }
        if (this.augmentTapper && TapperManager.mappingExists(this.inventory[0])) {
            FluidStack treeFluid = TapperManager.getFluid(this.inventory[0]).copy();
            this.tank.fill(treeFluid, true);
        }
        this.inventory[0].func_190918_g(this.curRecipe.getInput().func_190916_E());
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        int side;
        int i;
        if (!this.getTransferOut()) {
            return;
        }
        if (this.augmentTapper) {
            this.transferOutputFluid();
        }
        if (!this.inventory[1].func_190926_b()) {
            for (i = this.outputTrackerPrimary + 1; i <= this.outputTrackerPrimary + 6; ++i) {
                side = i % 6;
                if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.outputTrackerPrimary = side;
                break;
            }
        }
        if (this.inventory[2].func_190926_b()) {
            return;
        }
        for (i = this.outputTrackerSecondary + 1; i <= this.outputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (!SideConfig.isSecondaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(2, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTrackerSecondary = side;
            break;
        }
    }

    private void transferOutputFluid() {
        if (!this.getTransferOut()) {
            return;
        }
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!SideConfig.isSecondaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    @Override
    public void func_73660_a() {
        if (this.augmentTapper && this.timeCheckEighth()) {
            this.transferOutput();
        }
        super.func_73660_a();
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiSawmill(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerSawmill(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean augmentTapper() {
        return this.augmentTapper && this.flagTapper;
    }

    public boolean fluidArrow() {
        return this.augmentTapper && TapperManager.mappingExists(this.inventory[0]);
    }

    @Override
    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTrackerPrimary = nbt.func_74762_e("TrackOut");
        this.outputTrackerSecondary = nbt.func_74762_e("TrackOut2");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOut3");
        this.tank.readFromNBT(nbt);
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid().copy();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTrackerPrimary);
        nbt.func_74768_a("TrackOut2", this.outputTrackerSecondary);
        nbt.func_74768_a("Trackout3", this.outputTrackerFluid);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.augmentTapper);
        if (this.tank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.tank.getFluid());
        }
        return payload;
    }

    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.flagTapper = this.augmentTapper = payload.getBool();
        this.renderFluid = payload.getFluidStack();
        this.tank.setFluid(this.renderFluid);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.renderFluid = payload.getFluidStack();
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentTapper = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentTapper) {
            this.tank.clearLocked();
            this.tank.setFluid(null);
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentTapper && "machineSawmillTapper".equals(id)) {
            this.augmentTapper = true;
            this.hasModeAugment = true;
            this.energyMod += 50;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || SawmillManager.recipeExists(stack);
    }

    public SoundEvent getSoundEvent() {
        return TEProps.enableSounds ? TESounds.machineSawmill : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || this.augmentTapper && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (this.augmentTapper && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileSawmill.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileSawmill)TileSawmill.this).sideConfig.sideTypes[TileSawmill.this.sideCache[from.ordinal()]])) {
                        return TileSawmill.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileSawmill)TileSawmill.this).sideConfig.sideTypes[TileSawmill.this.sideCache[from.ordinal()]])) {
                        return TileSawmill.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

