/*
 * Decompiled with CFR 0.152.
 */
package com.leviathanstudio.craftstudio.client.model;

import com.leviathanstudio.craftstudio.client.model.CSModelBox;
import com.leviathanstudio.craftstudio.client.util.MathHelper;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CSModelRenderer
extends ModelRenderer {
    private int textureOffsetX;
    private int textureOffsetY;
    private boolean compiled;
    private int displayList;
    public List<CSModelBox> cubeCSList = new ArrayList<CSModelBox>();
    private final Matrix4f rotationMatrix = new Matrix4f();
    private Matrix4f prevRotationMatrix = new Matrix4f();
    private Vector3f stretch = new Vector3f(1.0f, 1.0f, 1.0f);
    private float defaultRotationPointX;
    private float defaultRotationPointY;
    private float defaultRotationPointZ;
    private Matrix4f defaultRotationMatrix = new Matrix4f();
    private Quat4f defaultRotationAsQuaternion;
    private float defaultOffsetX = 0.0f;
    private float defaultOffsetY = 0.0f;
    private float defaultOffsetZ = 0.0f;
    private Vector3f defaultStretch = new Vector3f(1.0f, 1.0f, 1.0f);

    public CSModelRenderer(ModelBase modelbase, String partName, int xTextureOffset, int yTextureOffset) {
        super(modelbase, partName);
        this.func_78787_b(modelbase.field_78090_t, modelbase.field_78089_u);
        this.func_78784_a(xTextureOffset, yTextureOffset);
    }

    public ModelRenderer func_78784_a(int x, int y) {
        this.textureOffsetX = x;
        this.textureOffsetY = y;
        this.field_78804_l.size();
        return this;
    }

    public ModelRenderer addBox(String name, CSModelBox modelBox) {
        name = this.field_78802_n + "." + name;
        this.cubeCSList.add(modelBox.setBoxName(name));
        return this;
    }

    public ModelRenderer addBox(String name, float par2, float par3, float par4, float par5, float par6, float par7) {
        name = this.field_78802_n + "." + name;
        this.cubeCSList.add(new CSModelBox(this, this.textureOffsetX, this.textureOffsetY, par2, par3, par4, par5, par6, par7).setBoxName(name));
        return this;
    }

    public ModelRenderer addBox(float posX, float posY, float posZ, float sizeX, float sizeY, float sizeZ) {
        this.cubeCSList.add(new CSModelBox(this, this.textureOffsetX, this.textureOffsetY, posX, posY, posZ, sizeX, sizeY, sizeZ));
        return this;
    }

    public ModelRenderer addBox(float posX, float posY, float posZ, float sizeX, float sizeY, float sizeZ, boolean mirror) {
        this.cubeCSList.add(new CSModelBox(this, this.textureOffsetX, this.textureOffsetY, posX, posY, posZ, sizeX, sizeY, sizeZ, mirror));
        return this;
    }

    public ModelRenderer addBox(PositionTextureVertex[] positionTextureVertex, int[][] textUVs) {
        this.cubeCSList.add(new CSModelBox(this, positionTextureVertex, textUVs));
        return this;
    }

    public ModelRenderer addBox(PositionTextureVertex[] positionTextureVertex, int[][] textUVs, boolean mirror) {
        this.cubeCSList.add(new CSModelBox(this, positionTextureVertex, textUVs, mirror));
        return this;
    }

    public ModelRenderer addBox(CSModelBox model) {
        this.cubeCSList.add(model);
        return this;
    }

    private static CSModelRenderer getModelRendererFromNameAndBlock(String name, CSModelRenderer block) {
        if (block.field_78802_n.equals(name)) {
            return block;
        }
        for (ModelRenderer child : block.field_78805_m) {
            CSModelRenderer childModel;
            CSModelRenderer result;
            if (!(child instanceof CSModelRenderer) || (result = CSModelRenderer.getModelRendererFromNameAndBlock(name, childModel = (CSModelRenderer)child)) == null) continue;
            return result;
        }
        return null;
    }

    public void func_78785_a(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            if (!this.compiled) {
                this.func_78788_d(scale);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
            FloatBuffer buf = MathHelper.makeFloatBuffer(this.rotationMatrix);
            GlStateManager.func_179110_a((FloatBuffer)buf);
            GlStateManager.func_179109_b((float)(this.field_82906_o * scale), (float)(this.field_82908_p * scale), (float)(this.field_82907_q * scale));
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)this.stretch.x, (float)this.stretch.y, (float)this.stretch.z);
            GlStateManager.func_179148_o((int)this.displayList);
            GlStateManager.func_179121_F();
            if (this.field_78805_m != null) {
                for (int i = 0; i < this.field_78805_m.size(); ++i) {
                    ((ModelRenderer)this.field_78805_m.get(i)).func_78785_a(scale);
                }
            }
            GlStateManager.func_179121_F();
            this.prevRotationMatrix = this.rotationMatrix;
        }
    }

    public void func_78794_c(float scale) {
    }

    public void func_78791_b(float scale) {
    }

    public void setDefaultRotationPoint(float x, float y, float z) {
        this.defaultRotationPointX = x;
        this.defaultRotationPointY = y;
        this.defaultRotationPointZ = z;
        this.func_78793_a(x, y, z);
    }

    public float getDefaultRotationPointX() {
        return this.defaultRotationPointX;
    }

    public float getDefaultRotationPointY() {
        return this.defaultRotationPointY;
    }

    public float getDefaultRotationPointZ() {
        return this.defaultRotationPointZ;
    }

    public void func_78793_a(float x, float y, float z) {
        this.field_78800_c = x;
        this.field_78797_d = y;
        this.field_78798_e = z;
    }

    public void resetRotationPoint() {
        this.field_78800_c = this.defaultRotationPointX;
        this.field_78797_d = this.defaultRotationPointY;
        this.field_78798_e = this.defaultRotationPointZ;
    }

    public Vector3f getPositionAsVector() {
        return new Vector3f(this.field_78800_c, this.field_78797_d, this.field_78798_e);
    }

    public void setDefaultOffset(float x, float y, float z) {
        this.defaultOffsetX = x;
        this.defaultOffsetY = y;
        this.defaultOffsetZ = z;
        this.setOffset(x, y, z);
    }

    public void setOffset(float x, float y, float z) {
        this.field_82906_o = x;
        this.field_82908_p = y;
        this.field_82907_q = z;
    }

    public void resetOffset() {
        this.field_82906_o = this.defaultOffsetX;
        this.field_82908_p = this.defaultOffsetY;
        this.field_82907_q = this.defaultOffsetZ;
    }

    public Vector3f getOffsetAsVector() {
        return new Vector3f(this.field_82906_o, this.field_82908_p, this.field_82907_q);
    }

    public void setDefaultStretch(float x, float y, float z) {
        this.defaultStretch = new Vector3f(x, y, z);
        this.setStretch(x, y, z);
    }

    public void setStretch(float x, float y, float z) {
        this.stretch = new Vector3f(x, y, z);
    }

    public void resetStretch() {
        this.stretch = this.defaultStretch;
    }

    public Vector3f getStretchAsVector() {
        return new Vector3f(this.stretch);
    }

    public void setInitialRotationMatrix(Matrix4f matrix) {
        this.defaultRotationMatrix = matrix;
        this.setRotationMatrix(matrix);
        Matrix4f mat = (Matrix4f)this.rotationMatrix.clone();
        mat.transpose();
        if (this.defaultRotationAsQuaternion == null) {
            this.defaultRotationAsQuaternion = new Quat4f();
        }
        this.defaultRotationAsQuaternion.set(mat);
    }

    public void setInitialRotationMatrix(float x, float y, float z) {
        Matrix4f mat = new Matrix4f();
        mat.set(MathHelper.quatFromEuler(x, y, z));
        mat.transpose();
        this.setInitialRotationMatrix(mat);
    }

    public void setRotationMatrix(Matrix4f matrix) {
        this.rotationMatrix.m00 = matrix.m00;
        this.rotationMatrix.m01 = matrix.m01;
        this.rotationMatrix.m02 = matrix.m02;
        this.rotationMatrix.m03 = matrix.m03;
        this.rotationMatrix.m10 = matrix.m10;
        this.rotationMatrix.m11 = matrix.m11;
        this.rotationMatrix.m12 = matrix.m12;
        this.rotationMatrix.m13 = matrix.m13;
        this.rotationMatrix.m20 = matrix.m20;
        this.rotationMatrix.m21 = matrix.m21;
        this.rotationMatrix.m22 = matrix.m22;
        this.rotationMatrix.m23 = matrix.m23;
        this.rotationMatrix.m30 = matrix.m30;
        this.rotationMatrix.m31 = matrix.m31;
        this.rotationMatrix.m32 = matrix.m32;
        this.rotationMatrix.m33 = matrix.m33;
    }

    public void resetRotationMatrix() {
        this.setRotationMatrix(this.defaultRotationMatrix);
    }

    public Matrix4f getRotationMatrix() {
        return this.rotationMatrix;
    }

    public Quat4f getDefaultRotationAsQuaternion() {
        return new Quat4f(this.defaultRotationAsQuaternion);
    }

    public void func_78788_d(float scale) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)this.displayList, (int)4864);
        BufferBuilder vertexbuffer = Tessellator.func_178181_a().func_178180_c();
        for (int i = 0; i < this.cubeCSList.size(); ++i) {
            this.cubeCSList.get(i).render(vertexbuffer, scale);
        }
        GlStateManager.func_187415_K();
        this.compiled = true;
    }

    public List<CSModelBox> getCubeCSList() {
        return this.cubeCSList;
    }
}

