/*
 * Decompiled with CFR 0.152.
 */
package com.leviathanstudio.craftstudio.proxy;

import com.leviathanstudio.craftstudio.CraftStudioApi;
import com.leviathanstudio.craftstudio.client.animation.ClientAnimationHandler;
import com.leviathanstudio.craftstudio.client.registry.CSRegistryHelper;
import com.leviathanstudio.craftstudio.client.registry.RegistryHandler;
import com.leviathanstudio.craftstudio.common.animation.AnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import com.leviathanstudio.craftstudio.proxy.CSCommonProxy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class CSClientProxy
extends CSCommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        this.loadCraftStudioLoaders(e);
    }

    @Override
    public <T extends IAnimated> AnimationHandler<T> getNewAnimationHandler(Class<T> animatedClass) {
        return new ClientAnimationHandler();
    }

    private void loadCraftStudioLoaders(FMLPreInitializationEvent e) {
        RegistryHandler.init();
        ASMDataTable dataTable = e.getAsmData();
        Set datas = dataTable.getAll("com.leviathanstudio.craftstudio.client.registry.CraftStudioLoader");
        for (ASMDataTable.ASMData data : datas) {
            String className = data.getClassName();
            String methodName = data.getObjectName().substring(0, data.getObjectName().indexOf("("));
            try {
                Method method = Class.forName(className).getMethod(methodName, new Class[0]);
                method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e1) {
                e1.printStackTrace();
                CraftStudioApi.getLogger().error("Error loading @CraftStudioLoader in class " + className + " for method " + methodName + "().");
                CraftStudioApi.getLogger().error("Does that method has arguments ? Because it should have none.");
            }
            catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e1) {
                e1.printStackTrace();
                CraftStudioApi.getLogger().error("Error loading craftstudio assets in class " + className + " for method " + methodName + "().");
                CraftStudioApi.getLogger().error("Is that method 'static' ? Because it should.");
            }
        }
        CSRegistryHelper.loadModels();
        CSRegistryHelper.loadAnims();
    }
}

