/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeUtils {
    private static Map<String, BiomeDictionary.Type> typeMap = new HashMap<String, BiomeDictionary.Type>();

    public static Set<Biome> getBiomesForType(String typeName) {
        BiomeDictionary.Type type = BiomeUtils.getType(typeName);
        return BiomeUtils.getBiomesForTypes(type);
    }

    public static BiomeDictionary.Type getType(String name) {
        if (typeMap.isEmpty()) {
            for (BiomeDictionary.Type type : BiomeDictionary.Type.getAll()) {
                typeMap.put(type.getName(), type);
            }
        }
        return typeMap.get(name.toUpperCase());
    }

    public static Set<Biome> getBiomesForTypes(BiomeDictionary.Type ... types) {
        HashSet<Biome> biomes = new HashSet<Biome>();
        for (BiomeDictionary.Type type : types) {
            if (type == null) continue;
            biomes.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
        }
        return biomes;
    }
}

