/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealthmod.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration config;
    public static boolean showEntityModel;
    public static boolean showDamageParticles;
    public static String entityStatusDisplay;
    public static String statusDisplayPosition;
    public static String skin;
    public static Integer statusDisplayX;
    public static Integer statusDisplayY;
    public static Integer damageColor;
    public static Integer healColor;
    public static int hideDelay;
    private static String[] acceptedColors;

    public static void init(File configFile) {
        config = new Configuration(configFile);
        ConfigurationHandler.loadConfiguration();
    }

    public static void loadConfiguration() {
        try {
            skin = config.getString("Skin", "client", "BASIC", "Background Skin Selection", new String[]{"NONE", "BASIC", "HEAVY"});
            showEntityModel = config.getBoolean("Show 3D Model of Entity", "client", true, "Shows a 3D model of the entity being targeted");
            entityStatusDisplay = config.getString("Health Bar Display", "client", "HEARTS", "Display Health Bars", new String[]{"HEARTS", "NUMERIC", "BAR", "OFF"});
            statusDisplayPosition = config.getString("Health Bar Position", "client", "TOP LEFT", "Location of Health Bar", new String[]{"TOP LEFT", "TOP CENTER", "TOP RIGHT", "BOTTOM LEFT", "BOTTOM RIGHT"});
            statusDisplayX = config.getInt("Health Bar X", "client", 0, -20000, 20000, "With CUSTOM position, sets X position of Health Bar");
            statusDisplayY = config.getInt("Health Bar Y", "client", 0, -20000, 20000, "With CUSTOM position, sets Y position of Health Bar");
            hideDelay = config.getInt("Hide Delay", "client", 400, 50, 5000, "Delays hiding the dialog for the given number of milliseconds");
            showDamageParticles = config.getBoolean("Show Damage Particles", "client", true, "Show Damage Indicators");
            healColor = ConfigurationHandler.mapColor(config.getString("Heal Color", "client", "GREEN", "Heal Text Color", acceptedColors));
            damageColor = ConfigurationHandler.mapColor(config.getString("Damage Color", "client", "RED", "Damage Text Color", acceptedColors));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChangeEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("torohealthmod")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static int mapColor(String color) {
        if (color.equals("RED")) {
            return 0xFF0000;
        }
        if (color.equals("GREEN")) {
            return 65280;
        }
        if (color.equals("BLUE")) {
            return 255;
        }
        if (color.equals("YELLOW")) {
            return 0xFFFF00;
        }
        if (color.equals("ORANGE")) {
            return 16753920;
        }
        if (color.equals("BLACK")) {
            return 0;
        }
        if (color.equals("PURPLE")) {
            return 0x960096;
        }
        return 0xFFFFFF;
    }

    static {
        acceptedColors = new String[]{"RED", "GREEN", "BLUE", "YELLOW", "ORANGE", "WHITE", "BLACK", "PURPLE"};
    }
}

