/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealthmod.display;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.math.MathHelper;
import net.torocraft.torohealthmod.display.AbstractHealthDisplay;
import net.torocraft.torohealthmod.display.ToroHealthDisplay;
import net.torocraft.torohealthmod.gui.GuiEntityStatus;

public class HeartsDisplay
extends AbstractHealthDisplay
implements ToroHealthDisplay {
    private final Minecraft mc;
    private final Gui gui;
    private int x;
    private int originX = 100;
    private int y;
    private int originY = 100;

    public HeartsDisplay(Minecraft mc, Gui gui) {
        this.mc = mc;
        this.gui = gui;
    }

    @Override
    public void setPosition(int x, int y) {
        this.originX = x;
        this.originY = y;
        this.resetToOrigin();
    }

    @Override
    public void draw() {
        if (this.entity == null) {
            return;
        }
        this.resetToOrigin();
        this.x += 4;
        this.y += 2;
        this.drawName();
        this.drawHearts();
        this.drawArmor();
    }

    private void resetToOrigin() {
        this.x = this.originX;
        this.y = this.originY;
    }

    private void drawName() {
        this.gui.func_73731_b(this.mc.field_71466_p, this.getEntityName(), this.x, this.y, 0xFFFFFF);
        this.y += 10;
    }

    private int drawHearts() {
        int absorptionAmount;
        this.mc.field_71446_o.func_110577_a(GuiEntityStatus.field_110324_m);
        int currentHealth = MathHelper.func_76123_f((float)this.entity.func_110143_aJ());
        int remainingAbsorption = absorptionAmount = MathHelper.func_76123_f((float)this.entity.func_110139_bj());
        float maxHealth = this.entity.func_110138_aP();
        int numRowsOfHearts = MathHelper.func_76123_f((float)((maxHealth + (float)absorptionAmount) / 2.0f / 10.0f));
        int j2 = Math.max(10 - (numRowsOfHearts - 2), 3);
        for (int currentHeartBeingDrawn = MathHelper.func_76123_f((float)((maxHealth + (float)absorptionAmount) / 2.0f)) - 1; currentHeartBeingDrawn >= 0; --currentHeartBeingDrawn) {
            int texturePosX = 16;
            int flashingHeartOffset = 0;
            int foeOffset = 0;
            if (this.determineRelation().equals((Object)AbstractHealthDisplay.Relation.FOE)) {
                foeOffset = 54;
            } else if (this.determineRelation().equals((Object)AbstractHealthDisplay.Relation.UNKNOWN)) {
                foeOffset = 18;
            }
            int rowsOfHearts = MathHelper.func_76123_f((float)((float)(currentHeartBeingDrawn + 1) / 10.0f)) - 1;
            int heartToDrawX = this.x + currentHeartBeingDrawn % 10 * 8;
            int heartToDrawY = this.y + rowsOfHearts * j2;
            int hardcoreModeOffset = 0;
            if (this.entity.field_70170_p.func_72912_H().func_76093_s()) {
                hardcoreModeOffset = 5;
            }
            this.gui.func_73729_b(heartToDrawX, heartToDrawY, 16 + flashingHeartOffset * 9, 9 * hardcoreModeOffset, 9, 9);
            if (remainingAbsorption > 0) {
                if (remainingAbsorption == absorptionAmount && absorptionAmount % 2 == 1) {
                    this.gui.func_73729_b(heartToDrawX, heartToDrawY, texturePosX + 153, 9 * hardcoreModeOffset, 9, 9);
                    --remainingAbsorption;
                    continue;
                }
                this.gui.func_73729_b(heartToDrawX, heartToDrawY, texturePosX + 144, 9 * hardcoreModeOffset, 9, 9);
                remainingAbsorption -= 2;
                continue;
            }
            if (currentHeartBeingDrawn * 2 + 1 < currentHealth) {
                this.gui.func_73729_b(heartToDrawX, heartToDrawY, texturePosX + foeOffset + 36, 9 * hardcoreModeOffset, 9, 9);
            }
            if (currentHeartBeingDrawn * 2 + 1 != currentHealth) continue;
            this.gui.func_73729_b(heartToDrawX, heartToDrawY, texturePosX + foeOffset + 45, 9 * hardcoreModeOffset, 9, 9);
        }
        this.y += (numRowsOfHearts - 1) * j2 + 10;
        return remainingAbsorption;
    }

    private void drawArmor() {
        this.mc.field_71446_o.func_110577_a(GuiEntityStatus.field_110324_m);
        int armor = this.entity.func_70658_aO();
        for (int i = 0; i < 10; ++i) {
            if (armor <= 0) continue;
            int armorIconX = this.x + i * 8;
            if (i * 2 + 1 < armor) {
                this.gui.func_73729_b(armorIconX, this.y, 34, 9, 9, 9);
            }
            if (i * 2 + 1 == armor) {
                this.gui.func_73729_b(armorIconX, this.y, 25, 9, 9, 9);
            }
            if (i * 2 + 1 <= armor) continue;
            this.gui.func_73729_b(armorIconX, this.y, 16, 9, 9, 9);
        }
        this.y += 10;
    }
}

