/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.item;

import cofh.core.render.IModelRegister;
import cofh.core.util.RayTracer;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.BlockHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemAttachment
extends Item
implements IInitializer,
IModelRegister {
    public ItemAttachment() {
        this.func_77627_a(true);
        this.func_77637_a(ThermalDynamics.tabUtils);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        Attachment attachment = ItemAttachment.getAttachment(stack, player, world, pos, facing);
        if (attachment != null && attachment.addToTile()) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static Attachment getAttachment(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        Attachment attachment = null;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileGrid) {
            int subHit;
            int s;
            RayTraceResult movingObjectPosition = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
            if (movingObjectPosition != null && (s = (subHit = movingObjectPosition.subHit) < 6 ? subHit : (subHit < 12 ? subHit - 6 : (subHit == 13 ? side.ordinal() : (subHit - 14) % 6))) != -1) {
                attachment = ((ItemAttachment)stack.func_77973_b()).getAttachment(EnumFacing.field_82609_l[s ^ 1], stack, (TileGrid)tile);
            }
        } else {
            tile = BlockHelper.getAdjacentTileEntity((World)world, (BlockPos)pos, (EnumFacing)side);
            if (tile instanceof TileGrid) {
                attachment = ((ItemAttachment)stack.func_77973_b()).getAttachment(side, stack, (TileGrid)tile);
            }
        }
        return attachment;
    }

    public abstract Attachment getAttachment(EnumFacing var1, ItemStack var2, TileGrid var3);

    public boolean initialize() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
    }
}

