/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.biome;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeForest;
import net.minecraft.world.biome.BiomeMesa;
import net.minecraft.world.biome.BiomeSwamp;

public class MapBiomes
extends Biome {
    public MapBiomes() {
        super(new Biome.BiomeProperties(""));
    }

    public int getBiomeGrassColour(int biomeId, Biome biome, BlockPos pos) {
        if (this.isVanilla(biomeId)) {
            if (biome instanceof BiomeForest) {
                return this.forestGrassColor(biomeId, biome, pos);
            }
            if (biome instanceof BiomeMesa) {
                return 9470285;
            }
            if (biome instanceof BiomeSwamp) {
                return this.swampGrassColor(pos);
            }
            return this.defaultGrassColor(biome, pos);
        }
        return biome.func_180627_b(pos);
    }

    public int getBiomeFoliageColour(int biomeId, Biome biome, BlockPos pos) {
        if (this.isVanilla(biomeId)) {
            if (biome instanceof BiomeMesa) {
                return 10387789;
            }
            if (biome instanceof BiomeSwamp) {
                return 6975545;
            }
            return this.defaultFoliageColor(biome, pos);
        }
        return biome.func_180625_c(pos);
    }

    public int getBiomeWaterColour(int biomeId, Biome biome) {
        if (this.isVanilla(biomeId)) {
            if (biome instanceof BiomeSwamp) {
                return 14745518;
            }
            return this.defaultWaterColor(biome);
        }
        return biome.getWaterColorMultiplier();
    }

    private boolean isVanilla(int biomeId) {
        return biomeId < 40 || biomeId == 127 || biomeId >= 129 && biomeId < 135 || biomeId == 140 || biomeId == 149 || biomeId == 151 || biomeId >= 155 && biomeId < 159 || biomeId >= 160 && biomeId < 168;
    }

    private int defaultGrassColor(Biome biome, BlockPos pos) {
        double d0 = MathHelper.func_76131_a((float)biome.func_180626_a(pos), (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
        return ColorizerGrass.func_77480_a((double)d0, (double)d1);
    }

    private int forestGrassColor(int biomeId, Biome biome, BlockPos pos) {
        int i = this.defaultGrassColor(biome, pos);
        return biomeId == 29 || biomeId == 157 ? (i & 0xFEFEFE) + 2634762 >> 1 : i;
    }

    private int swampGrassColor(BlockPos pos) {
        double d0 = field_180281_af.func_151601_a((double)pos.func_177958_n() * 0.0225, (double)pos.func_177952_p() * 0.0225);
        return d0 < -0.1 ? 5011004 : 6975545;
    }

    private int defaultFoliageColor(Biome biome, BlockPos pos) {
        double d0 = MathHelper.func_76131_a((float)biome.func_180626_a(pos), (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
        return ColorizerFoliage.func_77470_a((double)d0, (double)d1);
    }

    private int defaultWaterColor(Biome biome) {
        return 0xFFFFFF;
    }
}

