/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.core;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.network.play.server.SPacketMultiBlockChange;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.core.IWorldMapClientPlayNetHandler;
import xaero.map.file.MapSaveLoad;
import xaero.map.misc.Misc;
import xaero.map.patreon.Patreon;

public class XaeroWorldMapCore {
    public static Field chunkCleanField = null;
    public static WorldMapSession currentSession;
    private static boolean DETECTING_BLOCK_COLOR_RESOLVERS;
    private static Object DETECTING_BLOCK_COLOR_RESOLVERS_GRASS_COLOR;
    private static Object DETECTING_BLOCK_COLOR_RESOLVERS_FOLIAGE_COLOR;
    private static Object DETECTING_BLOCK_COLOR_RESOLVERS_WATER_COLOR;
    private static Object DETECTING_BLOCK_COLOR_RESOLVERS_RESULT;

    public static void ensureField() {
        if (chunkCleanField == null) {
            try {
                chunkCleanField = Chunk.class.getDeclaredField("xaero_wm_chunkClean");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroWorldMapCore.ensureField();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        Chunk chunk = world.func_72964_e(x, z);
                        if (chunk == null) continue;
                        chunkCleanField.set(chunk, false);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(SPacketChunkData packetIn) {
        XaeroWorldMapCore.chunkUpdateCallback(packetIn.func_149273_e(), packetIn.func_149271_f());
    }

    public static void onBlockChange(SPacketBlockChange packetIn) {
        XaeroWorldMapCore.chunkUpdateCallback(packetIn.func_179827_b().func_177958_n() >> 4, packetIn.func_179827_b().func_177952_p() >> 4);
    }

    public static void onMultiBlockChange(SPacketMultiBlockChange packetIn) {
        XaeroWorldMapCore.chunkUpdateCallback(packetIn.func_179844_a()[0].func_180090_a().func_177958_n() >> 4, packetIn.func_179844_a()[0].func_180090_a().func_177952_p() >> 4);
    }

    public static ResourceLocation getPlayerCape(AbstractClientPlayer player) {
        return Patreon.getPlayerCape(WorldMap.fileLayoutID, player);
    }

    public static Boolean isWearing(EntityPlayer player, EnumPlayerModelParts part) {
        if (part != EnumPlayerModelParts.CAPE || !(player instanceof AbstractClientPlayer)) {
            return null;
        }
        return Patreon.isWearingCape(WorldMap.fileLayoutID, (AbstractClientPlayer)player);
    }

    public static void onPlayNetHandler(NetHandlerPlayClient netHandler) {
        try {
            WorldMapSession worldmapSession;
            IWorldMapClientPlayNetHandler netHandlerAccess = (IWorldMapClientPlayNetHandler)netHandler;
            if (netHandlerAccess.getXaero_worldmapSession() != null) {
                return;
            }
            if (currentSession != null) {
                WorldMap.LOGGER.info("Previous world map session still active. Probably using MenuMobs. Forcing it to end...");
                XaeroWorldMapCore.cleanupCurrentSession();
            }
            currentSession = worldmapSession = new WorldMapSession();
            worldmapSession.init();
            netHandlerAccess.setXaero_worldmapSession(worldmapSession);
            WorldMap.settings.updateRegionCacheHashCode();
        }
        catch (Throwable e) {
            if (currentSession != null) {
                XaeroWorldMapCore.cleanupCurrentSession();
            }
            RuntimeException wrappedException = new RuntimeException("Exception initializing Xaero's World Map! ", e);
            WorldMap.crashHandler.setCrashedBy(wrappedException);
        }
    }

    private static void cleanupCurrentSession() {
        try {
            currentSession.cleanup();
        }
        catch (Throwable supressed) {
            WorldMap.LOGGER.error("suppressed exception", supressed);
        }
        finally {
            currentSession = null;
        }
    }

    public static void onPlayNetHandlerCleanup(NetHandlerPlayClient netHandler) {
        try {
            WorldMapSession netHandlerSession = ((IWorldMapClientPlayNetHandler)netHandler).getXaero_worldmapSession();
            if (netHandlerSession == null) {
                return;
            }
            try {
                netHandlerSession.cleanup();
            }
            finally {
                if (netHandlerSession == currentSession) {
                    currentSession = null;
                }
                ((IWorldMapClientPlayNetHandler)netHandler).setXaero_worldmapSession(null);
            }
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception finalizing Xaero's World Map! ", e);
            WorldMap.crashHandler.setCrashedBy(wrappedException);
        }
    }

    public static void onGetBlockColor(Object colorResolver) {
        if (DETECTING_BLOCK_COLOR_RESOLVERS && Minecraft.func_71410_x().func_152345_ab() && (DETECTING_BLOCK_COLOR_RESOLVERS_RESULT == null || XaeroWorldMapCore.isVanillaResolver(colorResolver) && !XaeroWorldMapCore.isVanillaResolver(DETECTING_BLOCK_COLOR_RESOLVERS_RESULT))) {
            DETECTING_BLOCK_COLOR_RESOLVERS_RESULT = colorResolver;
        }
    }

    private static boolean isVanillaResolver(Object colorResolver) {
        return colorResolver == DETECTING_BLOCK_COLOR_RESOLVERS_GRASS_COLOR || colorResolver == DETECTING_BLOCK_COLOR_RESOLVERS_FOLIAGE_COLOR || colorResolver == DETECTING_BLOCK_COLOR_RESOLVERS_WATER_COLOR;
    }

    public static Object detectColorResolver(IBlockState state, World world, BlockPos pos, Object GRASS_COLOR, Object FOLIAGE_COLOR, Object WATER_COLOR) {
        DETECTING_BLOCK_COLOR_RESOLVERS = true;
        DETECTING_BLOCK_COLOR_RESOLVERS_GRASS_COLOR = GRASS_COLOR;
        DETECTING_BLOCK_COLOR_RESOLVERS_FOLIAGE_COLOR = FOLIAGE_COLOR;
        DETECTING_BLOCK_COLOR_RESOLVERS_WATER_COLOR = WATER_COLOR;
        DETECTING_BLOCK_COLOR_RESOLVERS_RESULT = null;
        try {
            Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, 0);
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("suppressed exception", t);
        }
        DETECTING_BLOCK_COLOR_RESOLVERS = false;
        return DETECTING_BLOCK_COLOR_RESOLVERS_RESULT;
    }

    public static void onDeleteWorld(String saveName) {
        Path worldMapCacheFolder;
        if (!saveName.isEmpty() && (worldMapCacheFolder = MapSaveLoad.getRootFolder(saveName)).toFile().exists()) {
            try {
                Misc.deleteFile(worldMapCacheFolder, 20);
                WorldMap.LOGGER.info(String.format("Deleted world map cache at %s", worldMapCacheFolder));
            }
            catch (IOException e) {
                WorldMap.LOGGER.error(String.format("Failed to delete world map cache at %s!", worldMapCacheFolder), (Throwable)e);
            }
        }
    }

    static {
        DETECTING_BLOCK_COLOR_RESOLVERS_RESULT = null;
    }
}

