/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Util;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.file.RegionDetection;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.gui.GuiMap;
import xaero.map.misc.Misc;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.region.texture.LeafRegionTexture;

public class PNGExporter {
    private Path destinationPath;

    public PNGExporter(Path destinationPath) {
        this.destinationPath = destinationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(MapProcessor mapProcessor) throws IllegalArgumentException, IllegalAccessException, OpenGLException {
        BufferedImage image;
        long maxExportSizeInRegions;
        int n;
        if (!mapProcessor.getMapSaveLoad().isRegionDetectionComplete()) {
            WorldMap.LOGGER.info("Can't export the PNG just yet!");
            return;
        }
        List<LeveledRegion<?>> list = mapProcessor.getMapWorld().getCurrentDimension().getMapRegions().getUnsyncedList();
        if (list.isEmpty()) {
            return;
        }
        Integer minX = null;
        Integer maxX = null;
        Integer minZ = null;
        Integer maxZ = null;
        for (LeveledRegion<?> leveledRegion : list) {
            if (leveledRegion.getLevel() != 0) continue;
            if (minX == null || leveledRegion.getRegionX() < minX) {
                minX = leveledRegion.getRegionX();
            }
            if (maxX == null || leveledRegion.getRegionX() > maxX) {
                maxX = leveledRegion.getRegionX();
            }
            if (minZ == null || leveledRegion.getRegionZ() < minZ) {
                minZ = leveledRegion.getRegionZ();
            }
            if (maxZ != null && leveledRegion.getRegionZ() <= maxZ) continue;
            maxZ = leveledRegion.getRegionZ();
        }
        for (Hashtable hashtable : mapProcessor.getMapWorld().getCurrentDimension().getDetectedRegions().values()) {
            for (RegionDetection regionDetection : hashtable.values()) {
                if (minX == null || regionDetection.getRegionX() < minX) {
                    minX = regionDetection.getRegionX();
                }
                if (maxX == null || regionDetection.getRegionX() > maxX) {
                    maxX = regionDetection.getRegionX();
                }
                if (minZ == null || regionDetection.getRegionZ() < minZ) {
                    minZ = regionDetection.getRegionZ();
                }
                if (maxZ != null && regionDetection.getRegionZ() <= maxZ) continue;
                maxZ = regionDetection.getRegionZ();
            }
        }
        int exportWidthInRegions = maxX - minX + 1;
        long exportSizeInRegions = (long)exportWidthInRegions * (long)(n = maxZ - minZ + 1);
        if (exportSizeInRegions > (maxExportSizeInRegions = 0x6400000L)) {
            WorldMap.LOGGER.info("Can't export PNG because the map is too big: " + exportSizeInRegions);
            return;
        }
        float scale = exportSizeInRegions < 400L ? 1.0f : (float)(20.0 / Math.sqrt(exportSizeInRegions));
        float regionSize = 512.0f * scale;
        int exportWidth = (int)((float)exportWidthInRegions * regionSize);
        int exportHeight = (int)((float)n * regionSize);
        int maxTextureSize = GlStateManager.func_187397_v((int)3379);
        Util.checkGLError();
        int frameWidth = Math.min(1024, Math.min(maxTextureSize, exportWidth));
        int frameHeight = Math.min(1024, Math.min(maxTextureSize, exportHeight));
        int horizontalFrames = (int)Math.ceil((double)exportWidth / (double)frameWidth);
        int verticalFrames = (int)Math.ceil((double)exportHeight / (double)frameHeight);
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info(String.format("Exporting PNG of size %dx%d using a framebuffer of size %dx%d.", exportWidth, exportHeight, frameWidth, frameHeight));
        }
        try {
            image = new BufferedImage(exportWidth, exportHeight, 1);
        }
        catch (OutOfMemoryError oome) {
            WorldMap.LOGGER.info("Can't export PNG because java heap is out of memory. Required: " + (long)exportWidth * (long)exportHeight * 4L + " bytes");
            return;
        }
        ImprovedFramebuffer exportFrameBuffer = new ImprovedFramebuffer(frameWidth, frameHeight, false);
        ByteBuffer frameDataBuffer = BufferUtils.createByteBuffer((int)(frameWidth * frameHeight * 4));
        int[] bufferArray = new int[frameWidth * frameHeight];
        if (exportFrameBuffer.field_147616_f == -1) {
            WorldMap.LOGGER.info("Can't export PNG because FBOs are not supported.");
            return;
        }
        GlStateManager.func_179123_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)frameWidth, (double)0.0, (double)frameHeight, (double)0.0, (double)1000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179129_p();
        exportFrameBuffer.func_147610_a(true);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        for (int i = 0; i < horizontalFrames; ++i) {
            for (int j = 0; j < verticalFrames; ++j) {
                GlStateManager.func_179144_i((int)0);
                GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179086_m((int)16640);
                GlStateManager.func_179094_E();
                float frameLeft = (float)minX.intValue() * 512.0f + (float)(i * frameWidth) / scale;
                float frameRight = (float)minX.intValue() * 512.0f + (float)((i + 1) * frameWidth) / scale;
                float frameTop = (float)minZ.intValue() * 512.0f + (float)(j * frameHeight) / scale;
                float frameBottom = (float)minZ.intValue() * 512.0f + (float)((j + 1) * frameHeight) / scale;
                int minTileChunkX = (int)Math.floor(frameLeft) >> 6;
                int maxTileChunkX = (int)Math.floor(frameRight) >> 6;
                int minTileChunkZ = (int)Math.floor(frameTop) >> 6;
                int maxTileChunkZ = (int)Math.floor(frameBottom) >> 6;
                int minRegionX = minTileChunkX >> 3;
                int minRegionZ = minTileChunkZ >> 3;
                int maxRegionX = maxTileChunkX >> 3;
                int maxRegionZ = maxTileChunkZ >> 3;
                GlStateManager.func_179109_b((float)(-frameLeft), (float)(-frameTop), (float)0.0f);
                for (int regionX = minRegionX; regionX <= maxRegionX; ++regionX) {
                    for (int regionZ = minRegionZ; regionZ <= maxRegionZ; ++regionZ) {
                        boolean specialRegion = false;
                        MapRegion region = mapProcessor.getMapRegion(regionX, regionZ, false);
                        if (region == null || region.getLoadState() < 4 && (!region.isBeingWritten() || region.getLoadState() != 2)) {
                            File cacheFile = null;
                            if (region != null) {
                                cacheFile = region.getCacheFile();
                            } else if (mapProcessor.regionExists(regionX, regionZ)) {
                                cacheFile = mapProcessor.getRegionDetection(regionX, regionZ).getCacheFile();
                            }
                            if (cacheFile == null) continue;
                            region = new MapRegion("png", "null", null, null, regionX, regionZ, 0, false);
                            region.setCacheFile(cacheFile);
                            region.loadCacheTextures(mapProcessor, false, 1);
                            specialRegion = true;
                        }
                        for (int localChunkX = 0; localChunkX < 8; ++localChunkX) {
                            for (int localChunkZ = 0; localChunkZ < 8; ++localChunkZ) {
                                int textureId;
                                MapTileChunk tileChunk = region.getChunk(localChunkX, localChunkZ);
                                if (tileChunk == null) continue;
                                LeafRegionTexture tileChunkTexture = tileChunk.getLeafTexture();
                                if (tileChunk.getX() < minTileChunkX || tileChunk.getX() > maxTileChunkX || tileChunk.getZ() < minTileChunkZ || tileChunk.getZ() > maxTileChunkZ) {
                                    if (!specialRegion) continue;
                                    tileChunkTexture.deleteBuffers();
                                    continue;
                                }
                                if (specialRegion) {
                                    textureId = tileChunkTexture.bindColorTexture(true, 9728);
                                    if (tileChunkTexture.isColorBufferCompressed()) {
                                        GL13.glCompressedTexImage2D((int)3553, (int)0, (int)tileChunkTexture.getColorBufferFormat(), (int)64, (int)64, (int)0, (ByteBuffer)tileChunkTexture.getColorBuffer());
                                    } else {
                                        GL11.glTexImage2D((int)3553, (int)0, (int)tileChunkTexture.getColorBufferFormat(), (int)64, (int)64, (int)0, (int)32993, (int)32821, (ByteBuffer)tileChunkTexture.getColorBuffer());
                                    }
                                    tileChunkTexture.deleteBuffers();
                                } else {
                                    textureId = tileChunkTexture.bindColorTexture(false, 9728);
                                }
                                if (textureId == -1) continue;
                                GL11.glTexParameteri((int)3553, (int)33085, (int)9);
                                GlStateManager.func_187403_b((int)3553, (int)33083, (float)9.0f);
                                exportFrameBuffer.generateMipmaps();
                                GlStateManager.func_187421_b((int)3553, (int)10241, (int)9987);
                                GuiMap.renderTexturedModalRect(tileChunk.getX() * 64, tileChunk.getZ() * 64, 64.0f, 64.0f);
                                GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
                                if (!specialRegion) continue;
                                GlStateManager.func_179150_h((int)textureId);
                            }
                        }
                    }
                }
                GlStateManager.func_179121_F();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                exportFrameBuffer.func_147612_c();
                frameDataBuffer.clear();
                GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (ByteBuffer)frameDataBuffer);
                frameDataBuffer.asIntBuffer().get(bufferArray);
                int actualFrameWidth = Math.min(frameWidth, exportWidth - i * frameWidth);
                int actualFrameHeight = Math.min(frameHeight, exportHeight - j * frameWidth);
                image.setRGB(i * frameWidth, j * frameHeight, actualFrameWidth, actualFrameHeight, bufferArray, 0, frameWidth);
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
        exportFrameBuffer.func_147609_e();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        Misc.minecraftOrtho(new ScaledResolution(Minecraft.func_71410_x()));
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179144_i((int)0);
        exportFrameBuffer.func_147608_a();
        mapProcessor.getBufferDeallocator().deallocate(frameDataBuffer, WorldMap.settings.debug);
        Stream<Path> exports = null;
        try {
            Object[] exportsArray;
            if (!Files.exists(this.destinationPath, new LinkOption[0])) {
                Files.createDirectories(this.destinationPath, new FileAttribute[0]);
            }
            int exportNumber = 1;
            exports = Files.list(this.destinationPath);
            if (exports == null) {
                return;
            }
            for (Object o : exportsArray = exports.toArray()) {
                Path path = (Path)o;
                if (!path.getFileName().toString().endsWith("png")) continue;
                try {
                    int currentNumber = Integer.parseInt(path.getFileName().toString().split("\\.")[0].split("_")[1]);
                    if (currentNumber < exportNumber) continue;
                    exportNumber = currentNumber + 1;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ImageIO.write((RenderedImage)image, "png", this.destinationPath.resolve("export_" + exportNumber + ".png").toFile());
        }
        catch (IOException e1) {
            WorldMap.LOGGER.error("Failed to export PNG: ", (Throwable)e1);
        }
        finally {
            if (exports != null) {
                exports.close();
            }
            image.flush();
        }
    }
}

