/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import xaero.map.WorldMap;
import xaero.map.controls.ControlsRegister;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiSettings;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.MyTinyButton;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.settings.ModOptions;

public class GuiWorldMapSettings
extends GuiSettings {
    private static final int PAGES = 3;
    public GuiButton minimapButton;
    public GuiButton prevButton;
    public GuiButton nextButton;
    private int page;

    public GuiWorldMapSettings() {
        this(null);
    }

    public GuiWorldMapSettings(GuiScreen parent) {
        this(parent, null);
    }

    public GuiWorldMapSettings(GuiScreen parent, GuiScreen escapeScreen) {
        super(parent, escapeScreen, WorldMap.settings);
    }

    @Override
    public void func_73866_w_() {
        this.screenTitle = "Xaero's World Map Settings";
        this.options = this.page == 0 ? new ModOptions[]{ModOptions.LIGHTING, ModOptions.COLOURS, ModOptions.LOAD, ModOptions.UPDATE, ModOptions.DEPTH, ModOptions.SLOPES, ModOptions.STEPS, ModOptions.COORDINATES, ModOptions.WAYPOINTS, ModOptions.WAYPOINT_BACKGROUNDS, ModOptions.WAYPOINT_SCALE} : (this.page == 1 ? new ModOptions[]{ModOptions.MIN_ZOOM_LOCAL_WAYPOINTS, ModOptions.BIOMES, ModOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS, ModOptions.FLOWERS, ModOptions.ARROW, ModOptions.IGNORE_HEIGHTMAPS, ModOptions.ARROW_COLOUR, ModOptions.OPEN_ANIMATION, ModOptions.DISPLAY_ZOOM, ModOptions.ZOOM_BUTTONS, ModOptions.DETECT_AMBIGUOUS_Y} : new ModOptions[]{ModOptions.UPDATE_NOTIFICATION, ModOptions.RELOAD, ModOptions.DEBUG});
        super.func_73866_w_();
        if (this.page == 0) {
            this.minimapButton = new GuiButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 7 + 120, 200, 20, "Minimap Settings");
            this.func_189646_b(this.minimapButton);
            this.minimapButton.field_146124_l = SupportMods.minimap();
        }
        this.nextButton = new MyTinyButton(202, this.field_146294_l / 2 + 130, this.field_146295_m / 7 + 144, I18n.func_135052_a((String)"gui.xaero_wm_next", (Object[])new Object[0]));
        this.func_189646_b(this.nextButton);
        this.nextButton.field_146124_l = this.isNextButtonEnabled();
        this.prevButton = new MyTinyButton(203, this.field_146294_l / 2 - 205, this.field_146295_m / 7 + 144, I18n.func_135052_a((String)"gui.xaero_wm_previous", (Object[])new Object[0]));
        this.func_189646_b(this.prevButton);
        this.prevButton.field_146124_l = this.isPrevButtonEnabled();
        if (this.parent instanceof GuiMap) {
            this.func_189646_b(new GuiTexturedButton(0, 0, 30, 30, 113, 0, 20, 20, WorldMap.guiTextures, new Consumer<GuiButton>(){

                @Override
                public void accept(GuiButton b) {
                    GuiWorldMapSettings.this.onSettingsButton(b);
                }
            }, new CursorBox(I18n.func_135052_a((String)"gui.xaero_box_close_settings", (Object[])new Object[]{Misc.getKeyName(ControlsRegister.keyOpenSettings)}))));
        }
    }

    @Override
    protected void func_146284_a(GuiButton par1GuiButton) throws IOException {
        if (!this.renderedOnce) {
            return;
        }
        super.func_146284_a(par1GuiButton);
        if (par1GuiButton.field_146127_k == 201) {
            SupportMods.xaeroMinimap.openSettings(this.field_146297_k, this, this.escape);
        } else if (par1GuiButton == this.prevButton) {
            this.onPrevButton();
        } else if (par1GuiButton == this.nextButton) {
            this.onNextButton();
        }
    }

    private void onSettingsButton(GuiButton button) {
        this.goBack();
    }

    private void onPrevButton() {
        --this.page;
        if (this.page < 0) {
            this.page = 0;
        }
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    private void onNextButton() {
        ++this.page;
        if (this.page >= 3) {
            this.page = 2;
        }
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    private boolean isPrevButtonEnabled() {
        return this.page > 0;
    }

    private boolean isNextButtonEnabled() {
        return this.page < 2;
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        this.renderEscapeScreen(par1, par2, par3);
        super.func_73863_a(par1, par2, par3);
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton b = (GuiButton)this.field_146292_n.get(k);
            if (par1 >= b.field_146128_h && par2 >= b.field_146129_i && par1 < b.field_146128_h + 150 && par2 >= b.field_146129_i + 20) continue;
        }
    }
}

