/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.distribution.base;

import cofh.cofhworld.data.numbers.INumberProvider;
import cofh.cofhworld.parser.GeneratorData;
import cofh.cofhworld.parser.IDistributionParser;
import cofh.cofhworld.parser.IGeneratorParser;
import cofh.cofhworld.parser.variables.NumberData;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.world.distribution.Distribution;
import cofh.shade.com.typesafe.config.Config;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDistParser
implements IDistributionParser {
    private final String[] FIELDS = new String[]{"generator", "cluster-count"};
    protected final List<WeightedBlock> defaultMaterial = this.generateDefaultMaterial();

    protected AbstractDistParser() {
    }

    @Override
    public String[] getRequiredFields() {
        return this.FIELDS;
    }

    protected abstract List<WeightedBlock> generateDefaultMaterial();

    @Override
    @Nonnull
    public final Distribution getFeature(String featureName, Config genObject, boolean retrogen, Logger log) throws IDistributionParser.InvalidDistributionException {
        WorldGenerator generator;
        INumberProvider numClusters = NumberData.parseNumberValue(genObject.getValue("cluster-count"), 0, Long.MAX_VALUE);
        try {
            generator = GeneratorData.parseGenerator(this.getDefaultGenerator(), genObject, this.defaultMaterial);
        }
        catch (IGeneratorParser.InvalidGeneratorException e) {
            log.warn("Invalid generator for '{}' on line {}!", (Object)featureName, (Object)e.origin().lineNumber());
            throw new IDistributionParser.InvalidDistributionException("Invalid generator", e.origin()).causedBy(e);
        }
        return this.getFeature(featureName, genObject, generator, numClusters, retrogen, log);
    }

    @Nonnull
    protected abstract Distribution getFeature(String var1, Config var2, WorldGenerator var3, INumberProvider var4, boolean var5, Logger var6);

    protected String getDefaultGenerator() {
        return "cluster";
    }
}

