/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.type;

import com.creativemd.creativecore.common.config.api.CreativeConfig;
import com.creativemd.creativecore.common.utils.stack.InfoBlock;
import com.creativemd.creativecore.common.utils.stack.InfoContainOre;
import com.creativemd.creativecore.common.utils.stack.InfoItem;
import com.creativemd.creativecore.common.utils.stack.InfoItemStack;
import com.creativemd.creativecore.common.utils.stack.InfoMaterial;
import com.creativemd.creativecore.common.utils.stack.InfoName;
import com.creativemd.creativecore.common.utils.stack.InfoOre;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@CreativeConfig
public class SortingList
implements List<InfoStack> {
    @CreativeConfig
    public List<InfoStack> entries = new ArrayList<InfoStack>();
    @CreativeConfig
    public boolean isWhitelist;

    public SortingList(SortingList list) {
        this.isWhitelist = list.isWhitelist;
        this.entries = new ArrayList<InfoStack>(list.entries);
    }

    public SortingList() {
        this(true);
    }

    public SortingList(boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
    }

    public boolean isBlacklist() {
        return !this.isWhitelist;
    }

    public boolean isWhitelist() {
        return this.isWhitelist;
    }

    public void setListType(boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
    }

    public void setWhitelist() {
        this.isWhitelist = true;
    }

    public void setBlacklist() {
        this.isWhitelist = false;
    }

    public void addSortingObjects(Object ... objects) {
        for (int i = 0; i < objects.length; ++i) {
            this.addSortingObject(objects[i]);
        }
    }

    public void addSortingObject(Object object) {
        if (object instanceof InfoStack) {
            this.add((InfoStack)((Object)object));
            return;
        }
        InfoStack info = InfoStack.parseObject(object);
        if (info != null) {
            this.add(info);
        }
    }

    public void addSortingByNameContains(String name) {
        this.add(new InfoName(name));
    }

    public void addSortingByOreContains(String name) {
        this.add(new InfoContainOre(name));
    }

    public void addSortingByOre(String ore) {
        this.add(new InfoOre(ore));
    }

    public void addSortingByBlock(Block block) {
        this.add(new InfoBlock(block));
    }

    public void addSortingByItem(Item item) {
        this.add(new InfoItem(item));
    }

    public void addSortingByItemStack(ItemStack stack) {
        this.add(new InfoItemStack(stack));
    }

    public void addSortingByMaterial(Material material) {
        this.add(new InfoMaterial(material));
    }

    protected boolean canBeFoundInList(Object object) {
        InfoStack info = InfoStack.parseObject(object);
        if (info == null) {
            return false;
        }
        for (InfoStack infoStack : this.entries) {
            if (!infoStack.isInstanceIgnoreSize(infoStack)) continue;
            return true;
        }
        return false;
    }

    protected boolean canBeFoundInList(ItemStack stack) {
        for (InfoStack infoStack : this.entries) {
            if (!infoStack.isInstanceIgnoreSize(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean canPass(Object object) {
        return this.canBeFoundInList(object) == this.isWhitelist;
    }

    public boolean canPass(ItemStack stack) {
        return this.canBeFoundInList(stack) == this.isWhitelist;
    }

    @Override
    public boolean add(InfoStack arg0) {
        return this.entries.add(arg0);
    }

    @Override
    public void add(int arg0, InfoStack arg1) {
        this.entries.add(arg0, arg1);
    }

    @Override
    public boolean addAll(Collection<? extends InfoStack> arg0) {
        return this.addAll(arg0);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends InfoStack> arg1) {
        return this.addAll(arg0, arg1);
    }

    @Override
    public void clear() {
        this.entries = new ArrayList<InfoStack>();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.entries.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.entries.containsAll(arg0);
    }

    @Override
    public InfoStack get(int arg0) {
        return this.entries.get(arg0);
    }

    @Override
    public int indexOf(Object arg0) {
        return this.entries.indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<InfoStack> iterator() {
        return this.entries.iterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.entries.lastIndexOf(arg0);
    }

    @Override
    public ListIterator<InfoStack> listIterator() {
        return this.entries.listIterator();
    }

    @Override
    public ListIterator<InfoStack> listIterator(int arg0) {
        return this.entries.listIterator(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.entries.remove(arg0);
    }

    @Override
    public InfoStack remove(int arg0) {
        return this.entries.remove(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.entries.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.entries.retainAll(arg0);
    }

    @Override
    public InfoStack set(int index, InfoStack element) {
        return this.entries.set(index, element);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public List<InfoStack> subList(int fromIndex, int toIndex) {
        return this.entries.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.entries.toArray(a);
    }
}

