/*
 * Decompiled with CFR 0.152.
 */
package sct.hexxitgear.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import sct.hexxitgear.core.ability.Ability;
import sct.hexxitgear.core.ability.AbilityLift;
import sct.hexxitgear.core.ability.AbilityRampage;
import sct.hexxitgear.core.ability.AbilityShield;
import sct.hexxitgear.core.ability.AbilityStealth;
import sct.hexxitgear.core.buff.BuffMagicianSet;
import sct.hexxitgear.core.buff.BuffScaleSet;
import sct.hexxitgear.core.buff.BuffThiefSet;
import sct.hexxitgear.core.buff.BuffTribalSet;
import sct.hexxitgear.core.buff.IBuffHandler;
import sct.hexxitgear.init.HexRegistry;

public class ArmorSet {
    public static final Map<UUID, ArmorSet> CACHED_SETS = new HashMap<UUID, ArmorSet>();
    public static final List<ArmorSet> SETS = new ArrayList<ArmorSet>();
    public static final ArmorSet TRIBAL = new ArmorSet("Tribal", new Item[]{HexRegistry.TRIBAL_HELMET, HexRegistry.TRIBAL_CHEST, HexRegistry.TRIBAL_LEGS, HexRegistry.TRIBAL_BOOTS}, new BuffTribalSet(), new AbilityRampage());
    public static final ArmorSet THIEF = new ArmorSet("Thief", new Item[]{HexRegistry.THIEF_HELMET, HexRegistry.THIEF_CHEST, HexRegistry.THIEF_LEGS, HexRegistry.THIEF_BOOTS}, new BuffThiefSet(), new AbilityStealth());
    public static final ArmorSet SCALE = new ArmorSet("Scale", new Item[]{HexRegistry.SCALE_HELMET, HexRegistry.SCALE_CHEST, HexRegistry.SCALE_LEGS, HexRegistry.SCALE_BOOTS}, new BuffScaleSet(), new AbilityShield());
    public static final ArmorSet SAGE = new ArmorSet("Sage", new Item[]{HexRegistry.SAGE_HELMET, HexRegistry.SAGE_CHEST, HexRegistry.SAGE_LEGS, HexRegistry.SAGE_BOOTS}, new BuffMagicianSet(), new AbilityLift());
    private final Item[] armors;
    private final String name;
    private final IBuffHandler buffHandler;
    private final Ability ability;

    public ArmorSet(String name, Item[] armor, IBuffHandler buffHandler, Ability ability) {
        this.name = name;
        this.armors = armor;
        this.buffHandler = buffHandler;
        this.ability = ability;
        SETS.add(this);
    }

    public String getName() {
        return this.name;
    }

    public Item[] getArmors() {
        return this.armors;
    }

    public Ability getAbility() {
        return this.ability;
    }

    public void applyBuffs(EntityPlayer player) {
        this.buffHandler.applyPlayerBuffs(player);
    }

    public void removeBuffs(EntityPlayer player) {
        this.buffHandler.removePlayerBuffs(player);
    }

    @Nullable
    public static ArmorSet getCurrentArmorSet(EntityPlayer player) {
        Iterable curArmor = player.func_184193_aE();
        for (ArmorSet set : SETS) {
            int i = 0;
            int matched = 0;
            for (ItemStack s : curArmor) {
                if (s.func_190926_b() || s.func_77973_b() != set.armors[3 - i++]) continue;
                ++matched;
            }
            if (matched != 4) continue;
            return set;
        }
        return null;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        ArmorSet s = CACHED_SETS.get(e.player.func_110124_au());
        if (!e.player.field_70170_p.field_72995_K && s != null && ArmorSet.getCurrentArmorSet(e.player) != s) {
            s.removeBuffs(e.player);
            CACHED_SETS.put(e.player.func_110124_au(), null);
        }
    }

    public static void classloadForConfigs() {
    }
}

