/*
 * Decompiled with CFR 0.152.
 */
package sct.hexxitgear.init;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import sct.hexxitgear.core.ArmorSet;

public class HexConfig {
    public static File configFolder;
    public static Configuration config;
    private static final List<Integer> DIM_BLACKLIST;
    private static int hexbiscusChance;

    public static void loadCommonConfig(FMLPreInitializationEvent evt) {
        config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        HexConfig.registerDimBlacklist(config.getStringList("Dimensional Blacklist", "worldgen", new String[0], "Dimensions where hexbiscuses will not generate. New line per id."));
        ArmorSet.classloadForConfigs();
        hexbiscusChance = config.getInt("Hexbiscus Chance", "worldgen", 50, 1, 600, "The 1/n chance for a hexbiscus to generate. Lower numbers means more.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void registerDimBlacklist(String[] parsed) {
        for (String dim : parsed) {
            Integer dimID = Integer.parseInt(dim);
            if (DIM_BLACKLIST.contains(dimID)) continue;
            DIM_BLACKLIST.add(dimID);
        }
    }

    public static List<Integer> getDimBlacklist() {
        return DIM_BLACKLIST;
    }

    public static int getHexbiscusChance() {
        return hexbiscusChance;
    }

    static {
        DIM_BLACKLIST = new ArrayList<Integer>();
        hexbiscusChance = 0;
    }
}

