/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont;

import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontRendererHookList;
import bre.smoothfont.FontTexture;
import bre.smoothfont.FontUtils;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.util.GLUtils;
import bre.smoothfont.util.Logger;
import bre.smoothfont.util.ModLib;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class FontTextureManager
implements IResourceManagerReloadListener {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static FontTextureManager INSTANCE = new FontTextureManager();
    private final Map<ResourceLocation, ITextureObject> mapTextureObjects = Maps.newHashMap();
    private IResourceManager theResourceManager = mc.func_110442_L();
    public static final int MAX_PAGES = 257;
    public static final int DEFAULT_FONT = 256;

    public FontTextureManager() {
        ((IReloadableResourceManager)mc.func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
    }

    public static FontTextureManager getInstance() {
        return INSTANCE;
    }

    public FontTexture bindTexture(ResourceLocation resource) {
        Object itextureobject = this.mapTextureObjects.get(resource);
        if (itextureobject == null) {
            itextureobject = new FontTexture(resource);
            this.loadTexture(resource, (ITextureObject)itextureobject);
        } else if (((FontTexture)((Object)itextureobject)).needReload) {
            Logger.debug("Reloading texture: ", resource.toString());
            this.loadTexture(resource, (ITextureObject)itextureobject);
        }
        GlStateManager.func_179144_i((int)itextureobject.func_110552_b());
        return (FontTexture)((Object)itextureobject);
    }

    public boolean loadTexture(ResourceLocation textureLocation, ITextureObject textureObj) {
        boolean flag = true;
        try {
            textureObj.func_110551_a(this.theResourceManager);
        }
        catch (Exception e) {
            Logger.error("Failed to load texture: " + textureLocation);
            e.printStackTrace();
            this.mapTextureObjects.put(textureLocation, textureObj);
            flag = false;
        }
        this.mapTextureObjects.put(textureLocation, textureObj);
        return flag;
    }

    public void func_110549_a(IResourceManager iresourceManager) {
        this.clearMapTextureObjects();
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                frh.reloadResources();
                return true;
            }
        };
        hookList.executeAll();
    }

    public void clearMapTextureObjects() {
        ArrayList<ITextureObject> texObjList = new ArrayList<ITextureObject>(this.mapTextureObjects.values());
        try {
            for (ITextureObject texObj : texObjList) {
                ((AbstractTexture)texObj).func_147631_c();
            }
        }
        catch (RuntimeException re) {
            Logger.warn("Cannot delete Textures in the current thread.");
            re.printStackTrace();
            for (ITextureObject texObj : texObjList) {
                ((FontTexture)texObj).needReload = true;
            }
            return;
        }
        this.mapTextureObjects.clear();
    }

    public void setUnicodeFlagAll() {
        FontRendererHookList hookList = new FontRendererHookList(){

            @Override
            public boolean process(FontRendererHook frh) {
                FontRendererHook.setUnicodeFlagSuitably(frh);
                return true;
            }
        };
        hookList.executeAll();
    }

    public int getUnicodeFontRes(boolean osFont) {
        if (osFont) {
            return FontUtils.getFontRes(CommonConfig.currentConfig.fontResIndex);
        }
        FontRendererHook frh = FontRendererHook.getMcDefaultFontRendererHook();
        int texSize = 0;
        if (frh != null) {
            texSize = FontTextureManager.getInstance().getFontRes(frh.getUnicodePageLocation(0));
        }
        return texSize == 0 ? 16 : texSize;
    }

    public int getDefaultFontRes(ResourceLocation resourceLoc, boolean osFont) {
        if (osFont) {
            return FontUtils.getFontRes(CommonConfig.currentConfig.fontResIndex);
        }
        int texSize = FontTextureManager.getInstance().getFontRes(resourceLoc);
        return texSize == 0 ? 8 : texSize;
    }

    public int getFontRes(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj == null ? 0 : texObj.fontRes;
    }

    public float getActualFontRes(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj == null ? 0.0f : texObj.actualFontRes;
    }

    public float getChImageSizePx(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj == null ? 0.0f : texObj.chImageSizePx;
    }

    public float getBorderWidthPx(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj == null ? 0.0f : texObj.borderWidthPx;
    }

    public int getBlankSpacePx(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj == null ? 0 : texObj.blankSpacePx;
    }

    public int getTexSizePx(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj == null ? 0 : texObj.texSizePx;
    }

    private int getTexFilterSetting(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj == null ? 0 : texObj.texFilterSetting;
    }

    private void setTexFilterSetting(ResourceLocation resLoc, int id) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        if (texObj != null) {
            texObj.texFilterSetting = id;
        } else {
            Logger.error("setTexFilterSetting: textureObject is null.");
        }
    }

    private boolean getAnisotropicFilterSetting(ResourceLocation resLoc) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        return texObj != null && texObj.anisotropicFilterSetting;
    }

    private void setAnisotropicFilterSetting(ResourceLocation resLoc, boolean flag) {
        FontTexture texObj = (FontTexture)this.mapTextureObjects.get(resLoc);
        if (texObj != null) {
            texObj.anisotropicFilterSetting = flag;
        } else {
            Logger.error("setTexFilterSetting: textureObject is null.");
        }
    }

    public void setTexParams(ResourceLocation resLoc, int filterId) {
        if (this.getTexFilterSetting(resLoc) != filterId) {
            this.setTexFilterSetting(resLoc, filterId);
            if (CommonConfig.currentConfig.allowNPOTTexture) {
                GlStateManager.func_187421_b((int)3553, (int)10242, (int)33071);
                GlStateManager.func_187421_b((int)3553, (int)10243, (int)33071);
            }
            if (CommonConfig.currentConfig.enableInterpolation) {
                if (CommonConfig.currentConfig.enableMipmap) {
                    GlStateManager.func_187421_b((int)3553, (int)10241, (int)9987);
                } else {
                    GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
                }
                GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
            } else {
                if (CommonConfig.currentConfig.enableMipmap) {
                    GlStateManager.func_187421_b((int)3553, (int)10241, (int)9986);
                } else {
                    GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
                }
                GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
            }
        }
    }

    public void setTexParamsNearest(ResourceLocation resLoc) {
        if (this.getTexFilterSetting(resLoc) != 0) {
            this.setTexFilterSetting(resLoc, 0);
            if (CommonConfig.currentConfig.allowNPOTTexture) {
                GlStateManager.func_187421_b((int)3553, (int)10242, (int)33071);
                GlStateManager.func_187421_b((int)3553, (int)10243, (int)33071);
            }
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
        }
    }

    public void setAnisotropicFilter(ResourceLocation resLoc, boolean enable) {
        if (GLUtils.anisotropicFilterSupported) {
            if (enable) {
                if (!this.getAnisotropicFilterSetting(resLoc)) {
                    float maxAnisotropic = GL11.glGetFloat((int)34047);
                    GlStateManager.func_187403_b((int)3553, (int)34046, (float)maxAnisotropic);
                    this.setAnisotropicFilterSetting(resLoc, true);
                }
            } else if (this.getAnisotropicFilterSetting(resLoc)) {
                GlStateManager.func_187403_b((int)3553, (int)34046, (float)1.0f);
                this.setAnisotropicFilterSetting(resLoc, false);
            }
        }
    }

    public int getVramUsage() {
        int totalSize = 0;
        int pages = 0;
        Set<ResourceLocation> keyset = this.mapTextureObjects.keySet();
        Logger.debug("*** Texture information in VRAM ***");
        for (ResourceLocation resLoc : keyset) {
            FontTexture fontTexture = (FontTexture)this.mapTextureObjects.get(resLoc);
            if (fontTexture != null) {
                int textureSize = fontTexture.textureSize;
                Logger.debug("Texture-", fontTexture.page(), " : ", ModLib.humanReadableByteCountString(textureSize), " : width=", fontTexture.textureWidth);
                totalSize += textureSize;
                ++pages;
                continue;
            }
            Logger.error("Cannot bind the texture. textureobject is null. (" + resLoc.func_110623_a() + ")");
        }
        Logger.debug("Number of textures in VRAM: ", pages);
        return totalSize;
    }

    public int getNumOfLoadedTextures() {
        int num = this.mapTextureObjects.size();
        return num;
    }
}

