/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import de.pt400c.defaultsettings.CommandDefaultSettings_18;
import de.pt400c.defaultsettings.CommandDefaultSettings_19;
import de.pt400c.defaultsettings.CommandSwitchProfile_18;
import de.pt400c.defaultsettings.CommandSwitchProfile_19;
import de.pt400c.defaultsettings.EventHandlers;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.KeyContainer;
import de.pt400c.defaultsettings.UpdateContainer;
import de.pt400c.defaultsettings.font.FontRendererClass;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarInputStream;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="defaultsettings", acceptedMinecraftVersions="[1.8,1.12.2]", name="DefaultSettings", version="2.2.4", guiFactory="de.pt400c.defaultsettings.GuiConfigFactory", dependencies="before:*", certificateFingerprint="1945fa1cbb8ec2ffad2ccec7a0ca72ad52b20ef8", clientSideOnly=true, updateJSON="https://gist.githubusercontent.com/PT400C/be22046792a7859688f655f1a5f83975/raw/")
public class DefaultSettings {
    public static final String MODID = "defaultsettings";
    public static final String NAME = "DefaultSettings";
    public static final String VERSION = "2.2.4";
    public static final String modGuiFactory = "de.pt400c.defaultsettings.GuiConfigFactory";
    public static final Logger log = LogManager.getLogger((String)"defaultsettings");
    public static Map<String, Integer> keyRebinds_18 = new HashMap<String, Integer>();
    public static String mcVersion = FMLInjectionData.data()[4].toString();
    public static final String USER_AGENT = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.4; en-US; rv:1.9.2.2) Gecko/20100316 Firefox/3.6.2";
    public static Map<String, KeyContainer> keyRebinds_19 = new HashMap<String, KeyContainer>();
    private static final UpdateContainer updateContainer = new UpdateContainer();
    public static String BUILD_ID = "Unknown";
    public static String BUILD_TIME = "Unknown";
    public static FontRendererClass fontRenderer;
    public static final boolean is180;
    public static final boolean debug = false;
    public static int targetMS;
    public static boolean compatibilityMode;
    public static boolean antiAlias;
    @Mod.Instance
    public static DefaultSettings instance;

    public DefaultSettings() {
        instance = this;
    }

    @Mod.EventHandler
    public static void construction(FMLConstructionEvent event) {
        try {
            FileUtil.restoreContents();
        }
        catch (Exception e) {
            log.log(Level.ERROR, "An exception occurred while starting up the game:", (Throwable)e);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    DefaultSettings.sendCount();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    @Mod.EventHandler
    public static void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (event.isDirectory() || FileUtil.isDev) {
            return;
        }
        log.log(Level.ERROR, "The mod's files have been manipulated! The game will be terminated.");
        FMLCommonHandler.instance().exitJava(0, true);
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        if (mcVersion.startsWith("1.8")) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSwitchProfile_18());
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandDefaultSettings_18());
        } else {
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSwitchProfile_19());
            ClientCommandHandler.instance.func_71560_a((ICommand)new CommandDefaultSettings_19());
        }
        MinecraftForge.EVENT_BUS.register(DefaultSettings.class);
        EventHandlers handlers = new EventHandlers();
        FMLCommonHandler.instance().bus().register((Object)handlers);
        MinecraftForge.EVENT_BUS.register((Object)handlers);
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        fontRenderer = new FontRendererClass();
        ((IReloadableResourceManager)FileUtil.MC.func_110442_L()).func_110542_a((IResourceManagerReloadListener)fontRenderer);
        try {
            DefaultSettings.getBuildID();
            DefaultSettings.getBuildTime();
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public static void keysEvent(FMLLoadCompleteEvent event) {
        try {
            FileUtil.restoreKeys();
        }
        catch (IOException e) {
            log.log(Level.ERROR, "An exception occurred while starting up the game (Post):", (Throwable)e);
        }
        catch (NullPointerException e) {
            log.log(Level.ERROR, "An exception occurred while starting up the game (Post):", (Throwable)e);
        }
    }

    private static void getBuildID() throws FileNotFoundException, IOException {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)DefaultSettings.getInstance());
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(mc.getSource()));){
            BUILD_ID = jarStream.getManifest().getMainAttributes().getValue("Build-ID");
        }
    }

    private static void getBuildTime() throws FileNotFoundException, IOException {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)DefaultSettings.getInstance());
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(mc.getSource()));){
            BUILD_TIME = jarStream.getManifest().getMainAttributes().getValue("Build-Date");
        }
    }

    public static UpdateContainer getUpdater() {
        return updateContainer;
    }

    public static DefaultSettings getInstance() {
        return instance;
    }

    public static void sendCount() throws Exception {
        String url = "https://apiv1.jomcraft.net/count";
        String jsonString = "{\"id\":\"Defaultsettings\", \"code\":" + RandomStringUtils.random((int)32, (boolean)true, (boolean)true) + "}";
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("User-Agent", USER_AGENT);
        con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        con.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes(jsonString);
        wr.flush();
        wr.close();
        con.getResponseCode();
        con.disconnect();
    }

    static {
        is180 = mcVersion.equals("1.8");
        targetMS = 9;
        compatibilityMode = false;
        antiAlias = false;
    }
}

