/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.KeyContainer;
import de.pt400c.defaultsettings.MainJSON;
import de.pt400c.defaultsettings.PrivateJSON;
import de.pt400c.defaultsettings.gui.MenuArea;
import de.pt400c.defaultsettings.gui.MenuScreen;
import de.pt400c.defaultsettings.gui.ScrollableSegment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.logging.log4j.Level;

public class FileUtil {
    public static final Minecraft MC = Minecraft.func_71410_x();
    public static final File mcDataDir = FileUtil.MC.field_71412_D;
    public static final boolean isDev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static MainJSON mainJson;
    public static PrivateJSON privateJson;
    public static IgnoreJSON ignoreJson;
    public static volatile Thread registryChecker;
    public static volatile boolean options_exists;
    public static volatile boolean keys_exists;
    public static ArrayList<String> deleted;
    public static volatile boolean servers_exists;
    public static String activeProfile;
    public static boolean otherCreator;
    public static final FileFilter fileFilterModular;
    public static final FileFilter fileFilterAnti;
    public static final FileFilter fileFilter;
    public static final ArrayList<String> optUse;

    public static void setExportMode() throws IOException {
        for (File f : new File(mcDataDir, "config").listFiles(fileFilterModular)) {
            if (f.isDirectory()) {
                FileUtils.deleteDirectory((File)f);
                continue;
            }
            Files.delete(f.toPath());
        }
        mainJson.setExportMode(true);
        mainJson.save();
    }

    public static boolean exportMode() {
        return new File(mcDataDir, "config").listFiles(fileFilterModular).length == 0;
    }

    public static File getMainFolder() {
        File storeFolder = new File(mcDataDir, "config/defaultsettings");
        storeFolder.mkdir();
        return storeFolder;
    }

    public static void switchState(Byte state, final String query) {
        FileFilter ff = null;
        ff = !query.isEmpty() ? new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("servers.dat") && !new File(FileUtil.getMainFolder(), "sharedConfigs/" + file.getName()).exists() && file.getName().toLowerCase().startsWith(query.toLowerCase());
            }
        } : fileFilter;
        if (state == 1 || state == 2) {
            ArrayList<String> list = new ArrayList<String>(FileUtil.mainJson.activeConfigs);
            FileUtil.mainJson.activeConfigs.stream().filter(file -> file.toLowerCase().startsWith(query.toLowerCase()) && new File(mcDataDir + "/config", (String)file).exists()).forEach(file -> FileUtil.removeFromLists(list, file));
            FileUtil.mainJson.activeConfigs = list;
        } else if (state == 0) {
            File fileDir = new File(mcDataDir, "config");
            for (File file2 : fileDir.listFiles(ff)) {
                FileUtil.getMainJSON().activeConfigs.add(file2.getName());
            }
        }
        mainJson.save();
    }

    private static void removeFromLists(List<String> list, String file) {
        list.remove(file);
    }

    public static void setActive(String name, boolean active) {
        if (!active) {
            FileUtil.mainJson.activeConfigs.remove(name);
        } else if (!FileUtil.mainJson.activeConfigs.contains(name)) {
            FileUtil.mainJson.activeConfigs.add(name);
        }
        mainJson.save();
    }

    public static void switchActive(String name) {
        if (FileUtil.mainJson.activeConfigs.contains(name)) {
            FileUtil.mainJson.activeConfigs.remove(name);
        } else {
            FileUtil.mainJson.activeConfigs.add(name);
        }
        mainJson.save();
    }

    public static void initialSetupJSON() throws UnknownHostException, SocketException, NoSuchAlgorithmException {
        FileUtil.getPrivateJSON();
        String version = FileUtil.getMainJSON().getVersion();
        if (!"2.2.4".equals(version)) {
            mainJson.setVersion("2.2.4").setPrevVersion(version);
        }
        if (!FileUtil.privateJson.privateIdentifier.equals(FileUtil.mainJson.generatedBy) && !FileUtil.mainJson.generatedBy.equals("<default>")) {
            otherCreator = true;
        }
        mainJson.save();
    }

    public static IgnoreJSON getSharedIgnore(File location) {
        if (ignoreJson != null) {
            return ignoreJson;
        }
        if (location.exists()) {
            try (FileReader reader = new FileReader(location);){
                ignoreJson = (IgnoreJSON)gson.fromJson((Reader)reader, IgnoreJSON.class);
                ignoreJson.location = location;
            }
            catch (Exception e) {
                DefaultSettings.log.log(Level.ERROR, "Exception at processing startup: ", (Throwable)e);
            }
        } else {
            ignoreJson = new IgnoreJSON(location);
            ignoreJson.save();
        }
        return ignoreJson;
    }

    public static PrivateJSON getPrivateJSON() {
        if (privateJson != null) {
            return privateJson;
        }
        File privateFile = new File(mcDataDir, "ds_private_storage.json");
        if (privateFile.exists()) {
            try (FileReader reader = new FileReader(privateFile);){
                privateJson = (PrivateJSON)gson.fromJson((Reader)reader, PrivateJSON.class);
                if (FileUtil.privateJson.privateIdentifier == null || FileUtil.privateJson.privateIdentifier.isEmpty()) {
                    FileUtil.privateJson.privateIdentifier = UUID.randomUUID().toString();
                }
                privateJson.save();
            }
            catch (Exception e) {
                DefaultSettings.log.log(Level.ERROR, "Exception at processing startup: ", (Throwable)e);
            }
            DefaultSettings.compatibilityMode = FileUtil.privateJson.compatibilityMode;
        } else {
            privateJson = new PrivateJSON();
            FileUtil.privateJson.privateIdentifier = UUID.randomUUID().toString();
            privateJson.save();
        }
        return privateJson;
    }

    public static MainJSON getMainJSON() {
        block18: {
            if (mainJson != null) {
                return mainJson;
            }
            File mainFile = new File(mcDataDir, "config/defaultsettings.json");
            if (mainFile.exists()) {
                try (FileReader reader = new FileReader(mainFile);){
                    mainJson = (MainJSON)gson.fromJson((Reader)reader, MainJSON.class);
                    break block18;
                }
                catch (Exception e) {
                    DefaultSettings.log.log(Level.ERROR, "Exception at processing configs: ", (Throwable)e);
                    if (e instanceof JsonSyntaxException) {
                        mainFile.renameTo(new File(mcDataDir, "config/defaultsettings_malformed.json"));
                        FileUtil.getMainJSON();
                    }
                    break block18;
                }
            }
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            mainJson = new MainJSON().setVersion("2.2.4").setCreated(formatter.format(date));
            FileUtil.mainJson.initPopup = true;
            File fileDir = new File(mcDataDir, "config");
            for (File file : fileDir.listFiles(fileFilter)) {
                FileUtil.mainJson.activeConfigs.add(file.getName());
            }
            mainJson.save();
        }
        return mainJson;
    }

    public static void setPopup(boolean active) {
        FileUtil.mainJson.initPopup = active;
        mainJson.save();
    }

    public static void restoreContents() throws NullPointerException, IOException, NoSuchAlgorithmException {
        File serversFile;
        boolean firstBoot;
        FileUtil.initialSetupJSON();
        FileUtil.initialToDefaultProfile();
        String firstFolder = "<ERROR>";
        for (File file : FileUtil.getMainFolder().listFiles()) {
            if (!file.isDirectory() || file.getName().equals("sharedConfigs")) continue;
            firstFolder = file.getName();
            break;
        }
        if (!new File(FileUtil.getMainFolder(), FileUtil.mainJson.mainProfile).exists()) {
            FileUtil.mainJson.mainProfile = firstFolder;
        }
        if (FileUtil.privateJson.targetProfile.equals("!NEW!")) {
            FileUtil.privateJson.targetProfile = FileUtil.mainJson.mainProfile;
        }
        if (FileUtil.privateJson.currentProfile.equals("!NEW!")) {
            FileUtil.privateJson.currentProfile = FileUtil.mainJson.mainProfile;
        }
        if (!new File(FileUtil.getMainFolder(), FileUtil.privateJson.targetProfile).exists()) {
            FileUtil.privateJson.targetProfile = firstFolder;
        }
        if (!new File(FileUtil.getMainFolder(), FileUtil.privateJson.currentProfile).exists()) {
            FileUtil.privateJson.currentProfile = firstFolder;
        }
        privateJson.save();
        mainJson.save();
        boolean switchProf = FileUtil.switchProfile();
        activeProfile = FileUtil.privateJson.currentProfile;
        File options = new File(mcDataDir, "options.txt");
        boolean bl = firstBoot = !options.exists();
        if (firstBoot) {
            FileUtil.restoreOptions();
            if (!FileUtil.exportMode()) {
                FileUtil.moveAllConfigs();
            }
            FileUtil.restoreConfigs();
        } else if (mainJson.getExportMode() && !otherCreator || switchProf) {
            FileUtil.restoreConfigs();
            mainJson.setExportMode(false);
            mainJson.save();
        } else {
            if (otherCreator) {
                FileUtil.copyAndHashPrivate();
            }
            mainJson.setExportMode(false);
            mainJson.save();
        }
        File optionsOF = new File(mcDataDir, "optionsof.txt");
        if (!optionsOF.exists()) {
            FileUtil.restoreOptionsOF();
        }
        if (!(serversFile = new File(mcDataDir, "servers.dat")).exists()) {
            FileUtil.restoreServers();
        }
        GameSettings gameSettings = FileUtil.MC.field_71474_y;
        gameSettings.func_74300_a();
        ResourcePackRepository resourceRepository = MC.func_110438_M();
        resourceRepository.func_110611_a();
        ArrayList<ResourcePackRepository.Entry> repositoryEntries = new ArrayList<ResourcePackRepository.Entry>();
        for (String resourcePack : gameSettings.field_151453_l) {
            for (ResourcePackRepository.Entry entry : resourceRepository.func_110609_b()) {
                if (!entry.func_110515_d().equals(resourcePack)) continue;
                repositoryEntries.add(entry);
            }
        }
        resourceRepository.func_148527_a(repositoryEntries);
        FileUtil.MC.func_135016_M().field_135048_c = gameSettings.field_74363_ab;
        if (!options.exists()) {
            options.createNewFile();
        }
    }

    private static boolean switchProfile() throws IOException {
        if (!FileUtil.privateJson.currentProfile.equals(FileUtil.privateJson.targetProfile)) {
            Object paths;
            Date date = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH.mm.ss");
            String profileName = formatter.format(date);
            final File fileDir = new File(FileUtil.getMainFolder(), profileName);
            fileDir.mkdir();
            activeProfile = profileName;
            FileUtil.moveAllConfigs();
            FileUtil.checkMD5(true, false);
            String[] extensions = new String[]{"zip"};
            List oldestFiles = Collections.emptyList();
            Collection files = FileUtils.listFiles((File)FileUtil.getMainFolder(), (String[])extensions, (boolean)false);
            if (files.size() >= 10) {
                List list2 = files.stream().map(File::toPath).collect(Collectors.toList());
                Comparator lastModifiedComparator = (p1, p2) -> Long.compare(p1.toFile().lastModified(), p2.toFile().lastModified());
                paths = list2.stream();
                Throwable throwable = null;
                try {
                    oldestFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted(lastModifiedComparator).limit(files.size() - 8).collect(Collectors.toList());
                    oldestFiles.stream().forEach(t -> {
                        try {
                            Files.delete(t);
                        }
                        catch (IOException e) {
                            DefaultSettings.log.log(Level.ERROR, "Exception while processing profiles: ", (Throwable)e);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (paths != null) {
                        if (throwable != null) {
                            try {
                                paths.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            paths.close();
                        }
                    }
                }
            }
            Path pf = new File(FileUtil.getMainFolder(), profileName + ".zip").toPath();
            Files.createFile(pf, new FileAttribute[0]);
            ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(pf, new OpenOption[0]));
            paths = null;
            try {
                Path pt = Paths.get(fileDir.getPath(), new String[0]);
                Files.walk(pt, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                    ZipEntry zipEntry = new ZipEntry(pt.relativize((Path)path).toString());
                    try {
                        zos.putNextEntry(zipEntry);
                        Files.copy(path, zos);
                        zos.closeEntry();
                    }
                    catch (IOException e) {
                        DefaultSettings.log.log(Level.ERROR, "Exception while processing profiles: ", (Throwable)e);
                    }
                });
            }
            catch (Throwable throwable) {
                paths = throwable;
                throw throwable;
            }
            finally {
                if (zos != null) {
                    if (paths != null) {
                        try {
                            zos.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)paths).addSuppressed(throwable);
                        }
                    } else {
                        zos.close();
                    }
                }
            }
            try {
                deleted.add(fileDir.getName());
                FileUtils.deleteDirectory((File)fileDir);
            }
            catch (IOException e) {
                Thread thread = new Thread("File deletion thread"){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(10000L);
                            FileUtils.deleteDirectory((File)fileDir);
                        }
                        catch (IOException | InterruptedException exception) {
                            // empty catch block
                        }
                    }
                };
                thread.start();
                try {
                    FileUtils.forceDeleteOnExit((File)fileDir);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            FileUtil.privateJson.currentProfile = activeProfile = FileUtil.privateJson.targetProfile;
            privateJson.save();
            return true;
        }
        return false;
    }

    private static void initialToDefaultProfile() {
        if (FileUtil.getMainJSON().mainProfile.equals("!NEW!")) {
            new File(FileUtil.getMainFolder(), "Default").mkdir();
            FileFilter ffm = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.getName().equals("Default");
                }
            };
            try {
                FileUtils.copyDirectory((File)FileUtil.getMainFolder(), (File)new File(FileUtil.getMainFolder(), "Default"), (FileFilter)ffm);
            }
            catch (IOException e) {
                DefaultSettings.log.log(Level.ERROR, "Couldn't move config files: ", (Throwable)e);
            }
            for (File f : FileUtil.getMainFolder().listFiles(ffm)) {
                try {
                    if (f.isDirectory()) {
                        FileUtils.deleteDirectory((File)f);
                        continue;
                    }
                    Files.delete(f.toPath());
                }
                catch (IOException e) {
                    DefaultSettings.log.log(Level.ERROR, "Couldn't move config files: ", (Throwable)e);
                }
            }
            FileUtil.privateJson.targetProfile = "Default";
            privateJson.save();
            FileUtil.getMainJSON().mainProfile = "Default";
            mainJson.save();
        }
        String firstFolder = "<ERROR>";
        for (File file : FileUtil.getMainFolder().listFiles()) {
            if (!file.isDirectory() || file.getName().equals("sharedConfigs")) continue;
            firstFolder = file.getName();
            break;
        }
        if (firstFolder.equals("<ERROR>")) {
            new File(FileUtil.getMainFolder(), "Default").mkdir();
            FileUtil.privateJson.targetProfile = "Default";
            privateJson.save();
            FileUtil.getMainJSON().mainProfile = "Default";
            mainJson.save();
        }
        File shared = new File(FileUtil.getMainFolder(), "sharedConfigs");
        shared.mkdir();
        FileUtil.getSharedIgnore(new File(shared, "ignore.json"));
    }

    private static void copyAndHashPrivate() throws NullPointerException, IOException {
        File file;
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String opt : optUse) {
            File optFile = new File(FileUtil.getMainFolder(), activeProfile + "/" + opt);
            if (!optFile.exists() || FileUtil.privateJson.currentHash.containsKey(activeProfile + "/" + opt) && FileUtil.privateJson.currentHash.get(activeProfile + "/" + opt).equals(FileUtil.mainJson.hashes.get(activeProfile + "/" + opt))) continue;
            if (opt.equals("options.txt")) {
                FileUtil.restoreOptions();
            } else if (opt.equals("optionsof.txt")) {
                FileUtil.restoreOptionsOF();
            } else if (opt.equals("servers.dat")) {
                FileUtil.restoreServers();
            }
            FileUtil.privateJson.currentHash.put(activeProfile + "/" + opt, FileUtil.mainJson.hashes.get(activeProfile + "/" + opt));
        }
        Collection shared = FileUtils.listFilesAndDirs((File)new File(FileUtil.getMainFolder(), "sharedConfigs/"), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File sharedFile : shared) {
            if (sharedFile.getName().equals("ignore.json")) continue;
            file = new File(mcDataDir, "config");
            String name = sharedFile.getName();
            File fileInner = new File(file, sharedFile.getName());
            try {
                File locInDir = new File(FileUtil.getMainFolder(), "sharedConfigs/" + name);
                if (locInDir.isDirectory()) {
                    Collection files = FileUtils.listFilesAndDirs((File)locInDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                    for (File filePers : files) {
                        if (filePers.isDirectory()) continue;
                        String loc = filePers.getPath().split("defaultsettings")[1].substring(1).split("sharedConfigs")[1].substring(1);
                        File configLoc = new File(file, loc);
                        File newF = new File(FileUtil.getMainFolder(), "sharedConfigs/" + loc);
                        if (configLoc.exists() && FileUtil.privateJson.currentHash.containsKey("sharedConfigs\\" + loc) && FileUtil.privateJson.currentHash.get("sharedConfigs\\" + loc).equals(FileUtil.mainJson.hashes.get("sharedConfigs\\" + loc)) || !newF.exists()) continue;
                        FileUtils.copyFile((File)newF, (File)configLoc);
                        FileUtil.privateJson.currentHash.put("sharedConfigs\\" + loc, FileUtil.mainJson.hashes.get("sharedConfigs\\" + loc));
                    }
                    continue;
                }
                if (fileInner.exists() && FileUtil.privateJson.currentHash.containsKey("sharedConfigs\\" + name) && FileUtil.privateJson.currentHash.get("sharedConfigs\\" + name).equals(FileUtil.mainJson.hashes.get("sharedConfigs\\" + name)) || !locInDir.exists()) continue;
                FileUtils.copyFile((File)locInDir, (File)fileInner);
                FileUtil.privateJson.currentHash.put("sharedConfigs\\" + name, FileUtil.mainJson.hashes.get("sharedConfigs\\" + name));
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    DefaultSettings.log.log(Level.DEBUG, "The file no longer exists: ", (Throwable)e);
                    continue;
                }
                DefaultSettings.log.log(Level.WARN, "Error while creating hash: ", (Throwable)e);
            }
        }
        for (String name : FileUtil.mainJson.activeConfigs) {
            file = new File(mcDataDir, "config");
            File fileInner = new File(file, name);
            try {
                File locInDir = new File(FileUtil.getMainFolder(), activeProfile + "/" + name);
                if (locInDir.isDirectory()) {
                    Collection files = FileUtils.listFilesAndDirs((File)locInDir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
                    for (File filePers : files) {
                        if (filePers.isDirectory()) continue;
                        String loc = filePers.getPath().split("defaultsettings")[1].substring(1).split(activeProfile)[1].substring(1);
                        File configLoc = new File(file, loc);
                        File newF = new File(FileUtil.getMainFolder(), activeProfile + "/" + loc);
                        if (configLoc.exists() && FileUtil.privateJson.currentHash.containsKey(activeProfile + "/" + loc) && FileUtil.privateJson.currentHash.get(activeProfile + "/" + loc).equals(FileUtil.mainJson.hashes.get(activeProfile + "/" + loc)) || !newF.exists()) continue;
                        FileUtils.copyFile((File)newF, (File)configLoc);
                        FileUtil.privateJson.currentHash.put(activeProfile + "/" + loc, FileUtil.mainJson.hashes.get(activeProfile + "/" + loc));
                    }
                    continue;
                }
                if (fileInner.exists() && FileUtil.privateJson.currentHash.containsKey(activeProfile + "/" + name) && FileUtil.privateJson.currentHash.get(activeProfile + "/" + name).equals(FileUtil.mainJson.hashes.get(activeProfile + "/" + name)) || !locInDir.exists()) continue;
                FileUtils.copyFile((File)locInDir, (File)fileInner);
                FileUtil.privateJson.currentHash.put(activeProfile + "/" + name, FileUtil.mainJson.hashes.get(activeProfile + "/" + name));
            }
            catch (IOException e) {
                if (e instanceof FileNotFoundException) {
                    DefaultSettings.log.log(Level.DEBUG, "The file no longer exists: ", (Throwable)e);
                    if (otherCreator) continue;
                    toRemove.add(name);
                    continue;
                }
                DefaultSettings.log.log(Level.WARN, "Error while creating hash: ", (Throwable)e);
            }
        }
        for (String remove : toRemove) {
            FileUtil.mainJson.activeConfigs.remove(remove);
        }
        privateJson.save();
        if (toRemove.size() > 0) {
            mainJson.save();
        }
    }

    public static boolean optionsFilesExist() {
        File optionsFile = new File(FileUtil.getMainFolder(), activeProfile + "/options.txt");
        File optionsofFile = new File(FileUtil.getMainFolder(), activeProfile + "/optionsof.txt");
        return optionsFile.exists() || optionsofFile.exists();
    }

    public static boolean keysFileExist() {
        File keysFile = new File(FileUtil.getMainFolder(), activeProfile + "/keys.txt");
        return keysFile.exists();
    }

    public static void deleteKeys() {
        new File(FileUtil.getMainFolder(), activeProfile + "/keys.txt").delete();
        keys_exists = false;
    }

    public static void deleteServers() {
        new File(FileUtil.getMainFolder(), activeProfile + "/servers.dat").delete();
        servers_exists = false;
    }

    public static void deleteOptions() {
        new File(FileUtil.getMainFolder(), activeProfile + "/options.txt").delete();
        new File(FileUtil.getMainFolder(), activeProfile + "/optionsof.txt").delete();
        options_exists = false;
    }

    public static void restoreOptions() throws NullPointerException, IOException {
        File optionsFile = new File(FileUtil.getMainFolder(), activeProfile + "/options.txt");
        if (optionsFile.exists()) {
            BufferedReader readerOptions = null;
            BufferedReader reader = null;
            PrintWriter writer = null;
            File opFile = new File(mcDataDir, "options.txt");
            boolean existed = false;
            ArrayList<String> list = new ArrayList<String>();
            try {
                String line;
                reader = new BufferedReader(new FileReader(optionsFile));
                if (opFile.exists()) {
                    String lineOptions;
                    existed = true;
                    readerOptions = new BufferedReader(new FileReader(opFile));
                    while ((lineOptions = readerOptions.readLine()) != null) {
                        if (!lineOptions.startsWith("key_")) continue;
                        list.add(lineOptions);
                    }
                }
                writer = new PrintWriter(new FileWriter(new File(mcDataDir, "options.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
                for (String entry : list) {
                    writer.print(entry + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                    if (existed) {
                        readerOptions.close();
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
    }

    public static void restoreKeys() throws NullPointerException, IOException, NumberFormatException {
        if (DefaultSettings.mcVersion.startsWith("1.8")) {
            DefaultSettings.keyRebinds_18.clear();
        } else {
            DefaultSettings.keyRebinds_19.clear();
        }
        File keysFile = new File(FileUtil.getMainFolder(), activeProfile + "/keys.txt");
        if (keysFile.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(keysFile));
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    if (DefaultSettings.mcVersion.startsWith("1.8")) {
                        DefaultSettings.keyRebinds_18.put(line.split(":")[0], Integer.parseInt(line.split(":")[1]));
                        continue;
                    }
                    DefaultSettings.keyRebinds_19.put(line.split(":")[0], new KeyContainer(Integer.parseInt(line.split(":")[1]), line.split(":").length > 2 ? KeyModifier.valueFromString((String)line.split(":")[2]) : KeyModifier.NONE));
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
            for (KeyBinding keyBinding : FileUtil.MC.field_71474_y.field_74324_K) {
                if (DefaultSettings.mcVersion.startsWith("1.8")) {
                    if (!DefaultSettings.keyRebinds_18.containsKey(keyBinding.func_151464_g())) continue;
                    keyBinding.field_151472_e = DefaultSettings.keyRebinds_18.get(keyBinding.func_151464_g());
                    keyBinding.func_151462_b(keyBinding.field_151472_e);
                    continue;
                }
                if (!DefaultSettings.keyRebinds_19.containsKey(keyBinding.func_151464_g())) continue;
                KeyContainer container = DefaultSettings.keyRebinds_19.get(keyBinding.func_151464_g());
                FileUtil.setField("keyModifierDefault", KeyBinding.class, keyBinding, container.modifier);
                keyBinding.field_151472_e = container.input;
                keyBinding.setKeyModifierAndCode(keyBinding.getKeyModifierDefault(), keyBinding.field_151472_e);
            }
            KeyBinding.func_74508_b();
        }
    }

    public static void restoreOptionsOF() throws IOException {
        File optionsOFFile = new File(FileUtil.getMainFolder(), activeProfile + "/optionsof.txt");
        if (optionsOFFile.exists()) {
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(optionsOFFile));
                writer = new PrintWriter(new FileWriter(new File(mcDataDir, "optionsof.txt")));
                while ((line = reader.readLine()) != null) {
                    writer.print(line + "\n");
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
        }
    }

    public static void restoreConfigs() throws IOException {
        FileUtils.copyDirectory((File)new File(FileUtil.getMainFolder(), activeProfile), (File)new File(mcDataDir, "config"), (FileFilter)fileFilterModular);
        optUse.stream().map(file -> new File(FileUtil.getMainFolder(), activeProfile + "/" + file)).filter(file -> file.exists()).forEach(file -> {
            try {
                FileUtils.copyFile((File)file, (File)new File(mcDataDir, file.getName()));
            }
            catch (IOException e) {
                DefaultSettings.log.log(Level.ERROR, "Process the files: ", (Throwable)e);
            }
        });
        FileUtils.copyDirectory((File)new File(FileUtil.getMainFolder(), "sharedConfigs/"), (File)new File(mcDataDir, "config"), (FileFilter)fileFilterModular);
        FileUtils.listFilesAndDirs((File)new File(FileUtil.getMainFolder(), activeProfile), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE).stream().filter(file -> !file.isDirectory()).forEach(file -> {
            try {
                FileUtil.privateJson.currentHash.put(activeProfile + "/" + file.getPath().split("defaultsettings")[1].substring(1).split(activeProfile)[1].substring(1), FileUtil.fileToHash(new FileInputStream((File)file)));
            }
            catch (IOException e) {
                DefaultSettings.log.log(Level.ERROR, "Process the files: ", (Throwable)e);
            }
        });
        mainJson.setExportMode(false);
        mainJson.save();
        privateJson.save();
    }

    public static void moveAllConfigs() throws IOException {
        FileUtil.mainJson.generatedBy = FileUtil.privateJson.privateIdentifier;
        File fileDir = new File(mcDataDir, "config");
        FileUtils.copyDirectory((File)fileDir, (File)new File(FileUtil.getMainFolder(), activeProfile), (FileFilter)fileFilterModular);
        for (File f : fileDir.listFiles(fileFilterModular)) {
            try {
                if (f.isDirectory()) {
                    FileUtils.deleteDirectory((File)f);
                    continue;
                }
                Files.delete(f.toPath());
            }
            catch (IOException e) {
                DefaultSettings.log.log(Level.ERROR, "Couldn't move config files: ", (Throwable)e);
            }
        }
        for (File file : new File(FileUtil.getMainFolder(), "sharedConfigs").listFiles()) {
            if (!new File(fileDir, file.getName()).exists()) continue;
            if (new File(fileDir, file.getName()).isDirectory()) {
                FileUtils.deleteDirectory((File)new File(fileDir, file.getName()));
                continue;
            }
            Files.delete(new File(fileDir, file.getName()).toPath());
        }
        FileUtils.copyDirectory((File)new File(FileUtil.getMainFolder(), activeProfile), (File)fileDir, (FileFilter)fileFilterAnti);
        for (File f : new File(FileUtil.getMainFolder(), activeProfile).listFiles(fileFilterAnti)) {
            try {
                if (f.isDirectory()) {
                    FileUtils.deleteDirectory((File)f);
                    continue;
                }
                Files.delete(f.toPath());
            }
            catch (IOException e) {
                DefaultSettings.log.log(Level.ERROR, "Couldn't move config files: ", (Throwable)e);
            }
        }
        mainJson.setExportMode(true);
        mainJson.save();
    }

    public static void restoreServers() throws IOException {
        try {
            File file = new File(FileUtil.getMainFolder(), activeProfile + "/servers.dat");
            if (file.exists()) {
                FileUtils.copyFile((File)file, (File)new File(mcDataDir, "servers.dat"));
            } else {
                DefaultSettings.log.log(Level.WARN, "Couldn't restore the server config as it's not included");
            }
        }
        catch (IOException e) {
            DefaultSettings.log.log(Level.ERROR, "Couldn't restore the server config: ", (Throwable)e);
        }
    }

    public static void saveKeys() throws IOException, NullPointerException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(new File(FileUtil.getMainFolder(), activeProfile + "/keys.txt")));
            for (KeyBinding keyBinding : FileUtil.MC.field_71474_y.field_74324_K) {
                if (DefaultSettings.mcVersion.startsWith("1.8")) {
                    writer.print(keyBinding.func_151464_g() + ":" + keyBinding.func_151463_i() + "\n");
                    continue;
                }
                writer.print(keyBinding.func_151464_g() + ":" + keyBinding.func_151463_i() + ":" + keyBinding.getKeyModifier().name() + "\n");
            }
        }
    }

    public static void saveOptions() throws NullPointerException, IOException {
        String line;
        FileUtil.MC.field_71474_y.func_74303_b();
        PrintWriter writer = null;
        BufferedReader reader = null;
        try {
            writer = new PrintWriter(new FileWriter(new File(FileUtil.getMainFolder(), activeProfile + "/options.txt")));
            reader = new BufferedReader(new FileReader(new File(mcDataDir, "options.txt")));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("key_")) continue;
                writer.print(line + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
        }
        if (!FMLClientHandler.instance().hasOptifine()) {
            return;
        }
        try {
            writer = new PrintWriter(new FileWriter(new File(FileUtil.getMainFolder(), activeProfile + "/optionsof.txt")));
            reader = new BufferedReader(new FileReader(new File(mcDataDir, "optionsof.txt")));
            while ((line = reader.readLine()) != null) {
                writer.print(line + "\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw e;
        }
        finally {
            try {
                reader.close();
                writer.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
        }
    }

    public static void saveServers() throws IOException {
        File serversFile = new File(mcDataDir, "servers.dat");
        if (serversFile.exists()) {
            FileUtils.copyFile((File)serversFile, (File)new File(FileUtil.getMainFolder(), activeProfile + "/servers.dat"));
        }
    }

    public static boolean serversFileExists() {
        File serversFile = new File(FileUtil.getMainFolder(), activeProfile + "/servers.dat");
        return serversFile.exists();
    }

    public static String getUUID(String uuid) throws NoSuchAlgorithmException {
        return FileUtil.stringToHash(uuid);
    }

    public static String stringToHash(String string) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(string.getBytes());
        byte[] digest = md.digest();
        return DatatypeConverter.printHexBinary((byte[])digest).toUpperCase();
    }

    public static String fileToHash(InputStream is) throws IOException {
        return DigestUtils.md5Hex((InputStream)is).toUpperCase();
    }

    private static void setField(String name, Class clazz, Object obj, Object value) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            DefaultSettings.log.log(Level.ERROR, "Reflection exception: ", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            DefaultSettings.log.log(Level.ERROR, "Reflection exception: ", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            DefaultSettings.log.log(Level.ERROR, "Reflection exception: ", (Throwable)e);
        }
        catch (SecurityException e) {
            DefaultSettings.log.log(Level.ERROR, "Reflection exception: ", (Throwable)e);
        }
    }

    public static InputStream getServersStream() throws IOException {
        File serversFile = new File(mcDataDir, "servers.dat");
        if (serversFile.exists()) {
            return new FileInputStream(serversFile);
        }
        return null;
    }

    public static InputStream getOptionsOFStream() throws IOException {
        File optionsFile = new File(mcDataDir, "optionsof.txt");
        if (optionsFile.exists()) {
            return new FileInputStream(optionsFile);
        }
        return null;
    }

    public static InputStream getOptionsShadersStream() throws IOException {
        File optionsFile = new File(mcDataDir, "optionsof.txt");
        if (optionsFile.exists()) {
            return new FileInputStream(optionsFile);
        }
        return null;
    }

    public static InputStream getKeysStream() throws IOException, NullPointerException {
        FileInputStream stream = null;
        File file = new File(FileUtil.getMainFolder(), activeProfile + "/keys.txt_temp");
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(file));
            for (KeyBinding keyBinding : FileUtil.MC.field_71474_y.field_74324_K) {
                if (DefaultSettings.mcVersion.startsWith("1.8")) {
                    writer.print(keyBinding.func_151464_g() + ":" + keyBinding.func_151463_i() + "\n");
                    continue;
                }
                writer.print(keyBinding.func_151464_g() + ":" + keyBinding.func_151463_i() + ":" + keyBinding.getKeyModifier().name() + "\n");
            }
            stream = new FileInputStream(file);
        }
        return stream;
    }

    public static InputStream getOptionsStream() throws IOException, NullPointerException {
        File keysFile = new File(mcDataDir, "options.txt");
        FileInputStream stream = null;
        if (keysFile.exists()) {
            BufferedReader reader = null;
            PrintWriter writer = null;
            File file = new File(FileUtil.getMainFolder(), activeProfile + "/options.txt_temp");
            try {
                String line;
                writer = new PrintWriter(new FileWriter(file));
                reader = new BufferedReader(new FileReader(keysFile));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("key_")) continue;
                    writer.print(line + "\n");
                }
                stream = new FileInputStream(file);
            }
            catch (IOException e) {
                throw e;
            }
            catch (NullPointerException e) {
                throw e;
            }
            finally {
                try {
                    reader.close();
                    writer.close();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (NullPointerException e) {
                    throw e;
                }
            }
            return stream;
        }
        return null;
    }

    public static boolean checkChanged() {
        boolean ret = false;
        try {
            InputStream keys = FileUtil.getKeysStream();
            InputStream options = FileUtil.getOptionsStream();
            InputStream optionsOF = FileUtil.getOptionsOFStream();
            InputStream optionsShaders = FileUtil.getOptionsShadersStream();
            InputStream servers = FileUtil.getServersStream();
            String hashO = "";
            String writtenHashO = "";
            if (options != null) {
                hashO = FileUtil.fileToHash(options);
                writtenHashO = FileUtil.mainJson.hashes.get(activeProfile + "/options.txt");
            }
            String hashK = "";
            String writtenHashK = "";
            if (keys != null) {
                hashK = FileUtil.fileToHash(keys);
                writtenHashK = FileUtil.mainJson.hashes.get(activeProfile + "/keys.txt");
            }
            String hashOF = "";
            String writtenHashOF = "";
            if (optionsOF != null) {
                hashOF = FileUtil.fileToHash(optionsOF);
                writtenHashOF = FileUtil.mainJson.hashes.get(activeProfile + "/optionsof.txt");
            }
            String hashShaders = "";
            String writtenHashShaders = "";
            if (optionsShaders != null) {
                hashShaders = FileUtil.fileToHash(optionsShaders);
                writtenHashShaders = FileUtil.mainJson.hashes.get(activeProfile + "/optionsshaders.txt");
            }
            String hashS = "";
            String writtenHashS = "";
            if (servers != null) {
                hashS = FileUtil.fileToHash(servers);
                writtenHashS = FileUtil.mainJson.hashes.get(activeProfile + "/servers.dat");
            }
            if (FileUtil.mainJson.hashes.containsKey(activeProfile + "/options.txt") && !hashO.equals(writtenHashO)) {
                ret = true;
            } else if (FileUtil.mainJson.hashes.containsKey(activeProfile + "/keys.txt") && !hashK.equals(writtenHashK)) {
                ret = true;
            } else if (FileUtil.mainJson.hashes.containsKey(activeProfile + "/optionsof.txt") && !hashOF.equals(writtenHashOF)) {
                ret = true;
            } else if (FileUtil.mainJson.hashes.containsKey(activeProfile + "/optionsshaders.txt") && !hashShaders.equals(writtenHashShaders)) {
                ret = true;
            } else if (FileUtil.mainJson.hashes.containsKey(activeProfile + "/servers.dat") && !hashS.equals(writtenHashS)) {
                ret = true;
            }
            options.close();
            File fileO = new File(FileUtil.getMainFolder(), activeProfile + "/options.txt_temp");
            Files.delete(fileO.toPath());
            keys.close();
            File fileK = new File(FileUtil.getMainFolder(), activeProfile + "/keys.txt_temp");
            Files.delete(fileK.toPath());
        }
        catch (Exception e) {
            DefaultSettings.log.log(Level.ERROR, "Error while saving configs: ", (Throwable)e);
        }
        return ret;
    }

    public static void checkMD5(boolean updateExisting, boolean configs) throws FileNotFoundException, IOException {
        Collection config = FileUtils.listFilesAndDirs((File)new File(FileUtil.getMainFolder(), activeProfile), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File configFile : config) {
            if (configFile.isDirectory() || configFile.getName().equals("ignore.json") || optUse.contains(configFile.getName()) && configs) continue;
            String relativePath = configFile.getPath().substring(mcDataDir.getPath().length());
            String pathString = activeProfile + "/" + relativePath.split("defaultsettings")[1].substring(1).split(activeProfile)[1].substring(1);
            if (!updateExisting && FileUtil.mainJson.hashes.containsKey(pathString)) continue;
            FileUtil.mainJson.hashes.put(pathString, FileUtil.fileToHash(new FileInputStream(configFile)));
        }
        Collection shared = FileUtils.listFilesAndDirs((File)new File(FileUtil.getMainFolder(), "sharedConfigs"), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File sharedFile : shared) {
            if (sharedFile.isDirectory() || sharedFile.getName().equals("ignore.json")) continue;
            String relativePath = sharedFile.getPath().substring(mcDataDir.getPath().length());
            String pathString = relativePath.split("defaultsettings")[1].substring(1);
            if (!updateExisting && FileUtil.mainJson.hashes.containsKey(pathString)) continue;
            FileUtil.mainJson.hashes.put(pathString, FileUtil.fileToHash(new FileInputStream(sharedFile)));
        }
        mainJson.save();
    }

    static {
        options_exists = false;
        keys_exists = false;
        deleted = new ArrayList();
        servers_exists = false;
        activeProfile = "Default";
        otherCreator = false;
        fileFilterModular = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("sharedConfigs") && !file.getName().equals("ignore.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("servers.dat") && (file.getPath().split("config")[1].split(Pattern.quote("\\")).length > 2 || FileUtil.getMainJSON().activeConfigs.contains(file.getName()));
            }
        };
        fileFilterAnti = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("sharedConfigs") && !file.getName().equals("ignore.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("servers.dat") && !FileUtil.getMainJSON().activeConfigs.contains(file.getName());
            }
        };
        fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("servers.dat") && !new File(FileUtil.getMainFolder(), "sharedConfigs/" + file.getName()).exists();
            }
        };
        optUse = new ArrayList<String>(){
            private static final long serialVersionUID = -6765486158086901202L;
            {
                this.add("options.txt");
                this.add("servers.dat");
                this.add("optionsof.txt");
                this.add("keys.txt");
            }
        };
    }

    public static class IgnoreJSON {
        public static final transient long serialVersionUID = 2349872L;
        public ArrayList<String> ignore = new ArrayList();
        private transient File location;

        public IgnoreJSON(File location) {
            this.location = location;
        }

        public void save() {
            try (FileWriter writer = new FileWriter(this.location);){
                gson.toJson((Object)this, (Appendable)writer);
            }
            catch (IOException e) {
                DefaultSettings.log.log(Level.ERROR, "Exception at processing startup: ", (Throwable)e);
            }
        }
    }

    public static class RegistryChecker {
        public RegistryChecker() {
            if (registryChecker != null) {
                return;
            }
            registryChecker = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        if (!(FileUtil.MC.field_71462_r instanceof GuiConfig)) break;
                        options_exists = FileUtil.optionsFilesExist();
                        keys_exists = FileUtil.keysFileExist();
                        servers_exists = FileUtil.serversFileExists();
                        GuiScreen gui = FileUtil.MC.field_71462_r;
                        if (gui instanceof GuiConfig && ((GuiConfig)gui).menu != null) {
                            MenuScreen menuScreen = ((GuiConfig)gui).menu;
                            synchronized (menuScreen) {
                                for (MenuArea variant : ((GuiConfig)gui).menu.getVariants()) {
                                    variant.getChildren().stream().filter(segment -> segment instanceof ScrollableSegment).forEach(segment -> segment.guiContentUpdate(((ScrollableSegment)segment).searchbar.query));
                                }
                            }
                        }
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            DefaultSettings.log.log(Level.ERROR, "Thread interrupted: ", (Throwable)e);
                        }
                    }
                    registryChecker = null;
                }
            });
            registryChecker.start();
        }
    }
}

