/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL32;

@SideOnly(value=Side.CLIENT)
public class FramebufferDefault {
    public int framebufferWidth;
    public int framebufferHeight;
    public int framebuffer = -1;
    public int interFramebuffer = -1;
    public int colorBuffer;
    public int multisampledTexture;
    public int screenTexture;

    public FramebufferDefault(int width, int height) {
        this.createBindFramebuffer(width, height);
    }

    public void createBindFramebuffer(int width, int height) {
        if (this.framebuffer >= 0) {
            this.deleteFramebuffer();
        }
        this.createFramebuffer(width, height);
        boolean bl = DefaultSettings.antiAlias = !OpenGlHelper.func_148822_b();
        if (DefaultSettings.antiAlias) {
            OpenGlHelper.func_153171_g((int)36160, (int)0);
        } else {
            FileUtil.MC.func_147110_a().func_147610_a(true);
        }
    }

    public void deleteFramebuffer() {
        if (DefaultSettings.antiAlias) {
            OpenGlHelper.func_153171_g((int)36160, (int)0);
        } else {
            FileUtil.MC.func_147110_a().func_147610_a(true);
        }
        OpenGlHelper.func_153174_h((int)this.framebuffer);
        OpenGlHelper.func_153174_h((int)this.interFramebuffer);
    }

    public void createFramebuffer(int width, int height) {
        this.framebufferWidth = width;
        this.framebufferHeight = height;
        this.createFrameBuffer();
        this.createMSColorAttachment();
        if (DefaultSettings.antiAlias) {
            OpenGlHelper.func_153171_g((int)36160, (int)0);
        } else {
            FileUtil.MC.func_147110_a().func_147610_a(true);
        }
        this.createMSFrameBuffer();
        this.createColorAttachment();
        this.framebufferClear();
    }

    private void createColorAttachment() {
        this.screenTexture = GlStateManager.func_179146_y();
        GlStateManager.func_179144_i((int)this.screenTexture);
        GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)this.framebufferWidth, (int)this.framebufferHeight, (int)0, (int)6407, (int)5121, (ByteBuffer)null);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        OpenGlHelper.func_153188_a((int)36160, (int)36064, (int)3553, (int)this.screenTexture, (int)0);
    }

    private void createFrameBuffer() {
        this.framebuffer = OpenGlHelper.func_153165_e();
        OpenGlHelper.func_153171_g((int)36160, (int)this.framebuffer);
    }

    private void createMSFrameBuffer() {
        this.interFramebuffer = OpenGlHelper.func_153165_e();
        OpenGlHelper.func_153171_g((int)36160, (int)this.interFramebuffer);
    }

    private void createMSColorAttachment() {
        this.multisampledTexture = GlStateManager.func_179146_y();
        GL11.glBindTexture((int)37120, (int)this.multisampledTexture);
        if (GL11.glGetError() != 0) {
            DefaultSettings.compatibilityMode = true;
            return;
        }
        GL32.glTexImage2DMultisample((int)37120, (int)Math.min(GL11.glGetInteger((int)36183), DefaultSettings.targetMS), (int)32856, (int)this.framebufferWidth, (int)this.framebufferHeight, (boolean)true);
        GL11.glBindTexture((int)3553, (int)0);
        OpenGlHelper.func_153188_a((int)36160, (int)36064, (int)37120, (int)this.multisampledTexture, (int)0);
    }

    public void framebufferClear() {
        GlStateManager.func_179086_m((int)16384);
        if (DefaultSettings.antiAlias) {
            OpenGlHelper.func_153171_g((int)36160, (int)0);
        } else {
            FileUtil.MC.func_147110_a().func_147610_a(true);
        }
    }

    public void resize(int width, int height) {
        OpenGlHelper.func_153174_h((int)this.framebuffer);
        OpenGlHelper.func_153174_h((int)this.interFramebuffer);
        GlStateManager.func_179150_h((int)this.screenTexture);
        GlStateManager.func_179150_h((int)this.multisampledTexture);
        this.createBindFramebuffer(width, height);
    }
}

