/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import de.pt400c.defaultsettings.DefaultSettings;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.apache.logging.log4j.Level;

public class UpdateContainer {
    private ExecutorService tpe = Executors.newFixedThreadPool(1);
    private Status status = Status.UNKNOWN;
    private String onlineVersion = null;

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setOnlineVersion(String version) {
        this.onlineVersion = version;
    }

    public String getOnlineVersion() {
        return this.onlineVersion;
    }

    public Status getStatus() {
        return this.status;
    }

    public void update() {
        this.setStatus(Status.CHECKING);
        this.tpe.submit(new Runnable(){

            @Override
            public void run() {
                ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)DefaultSettings.getInstance());
                ForgeVersion.Status status = ForgeVersion.Status.PENDING;
                ComparableVersion target = null;
                try {
                    InputStream con = UpdateContainer.openUrlStream(mc.getUpdateUrl());
                    String data = new String(ByteStreams.toByteArray((InputStream)con), "UTF-8");
                    con.close();
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    Map promos = (Map)json.get("promos");
                    String rec = (String)promos.get(DefaultSettings.mcVersion + "-recommended");
                    String lat = (String)promos.get(DefaultSettings.mcVersion + "-latest");
                    ComparableVersion current = new ComparableVersion(mc.getVersion());
                    if (rec != null) {
                        ComparableVersion recommended = new ComparableVersion(rec);
                        int diff = recommended.compareTo(current);
                        if (diff == 0) {
                            status = ForgeVersion.Status.UP_TO_DATE;
                        } else if (diff < 0) {
                            ComparableVersion latest;
                            status = ForgeVersion.Status.AHEAD;
                            if (lat != null && current.compareTo(latest = new ComparableVersion(lat)) < 0) {
                                status = ForgeVersion.Status.OUTDATED;
                                target = latest;
                            }
                        } else {
                            status = ForgeVersion.Status.OUTDATED;
                            target = recommended;
                        }
                    } else if (lat != null) {
                        ComparableVersion latest = new ComparableVersion(lat);
                        if (current.compareTo(latest) < 0) {
                            status = ForgeVersion.Status.BETA_OUTDATED;
                            target = latest;
                        } else {
                            status = ForgeVersion.Status.BETA;
                        }
                    } else {
                        status = ForgeVersion.Status.BETA;
                    }
                }
                catch (IOException e) {
                    DefaultSettings.log.log(Level.ERROR, "Error while checking for updates: ", (Throwable)e);
                    DefaultSettings.getUpdater().setStatus(Status.ERROR);
                    return;
                }
                if (target != null) {
                    DefaultSettings.getUpdater().setOnlineVersion(target.toString());
                }
                switch (status) {
                    case BETA: {
                        DefaultSettings.getUpdater().setStatus(Status.UP_TO_DATE);
                        break;
                    }
                    case BETA_OUTDATED: {
                        DefaultSettings.getUpdater().setStatus(Status.OUTDATED);
                        break;
                    }
                    case UP_TO_DATE: {
                        DefaultSettings.getUpdater().setStatus(Status.UP_TO_DATE);
                        break;
                    }
                    case AHEAD: {
                        DefaultSettings.getUpdater().setStatus(Status.AHEAD_OF_TIME);
                        break;
                    }
                    case OUTDATED: {
                        DefaultSettings.getUpdater().setStatus(Status.OUTDATED);
                        break;
                    }
                    case PENDING: {
                        DefaultSettings.getUpdater().setStatus(Status.CHECKING);
                        break;
                    }
                    default: {
                        DefaultSettings.getUpdater().setStatus(Status.ERROR);
                    }
                }
            }
        });
    }

    public static InputStream openUrlStream(URL url) throws IOException {
        InputStream stream = null;
        URLConnection con = url.openConnection();
        con.setConnectTimeout(5000);
        if (con instanceof HttpURLConnection) {
            HttpURLConnection huc = (HttpURLConnection)con;
            huc.setInstanceFollowRedirects(false);
            int responseCode = huc.getResponseCode();
            if (responseCode == 200) {
                stream = con.getInputStream();
                return stream;
            }
        }
        throw new IOException("Couldn't create a proper connection to the remote host");
    }

    public static enum Status {
        UNKNOWN,
        CHECKING,
        UP_TO_DATE,
        OUTDATED,
        ERROR,
        AHEAD_OF_TIME;

    }
}

