/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.FramebufferPopup;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.Segment;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@SideOnly(value=Side.CLIENT)
public abstract class BakedSegment
extends Segment {
    protected boolean updateForced = false;
    public boolean compiled = false;
    protected FramebufferPopup mapFrameBuffer;
    protected int bufferWidth = (int)(this.width * (float)scaledresolution.func_78325_e());
    protected int bufferHeight = (int)(this.height * (float)scaledresolution.func_78325_e());
    protected int id;
    protected int heightBuffer;
    protected int widthBuffer;
    protected final boolean stat;
    private final int red;
    private final int green;
    private final int blue;

    public BakedSegment(GuiScreen gui, int id, float posX, float posY, float width, float height, int red, int green, int blue, boolean stat, boolean popupSegment) {
        super(gui, posX, posY, width, height, popupSegment);
        this.mapFrameBuffer = new FramebufferPopup(this.bufferWidth, this.bufferHeight);
        this.stat = stat;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void setup() {
        if (this.updateForced) {
            this.compiled = false;
            this.updateForced = false;
        }
        if (resized != this.resized_mark) {
            this.bufferWidth = (int)(this.width * (float)scaledresolution.func_78325_e());
            this.bufferHeight = (int)(this.height * (float)scaledresolution.func_78325_e());
            this.mapFrameBuffer.resize(this.bufferWidth, this.bufferHeight);
            this.resized_mark = resized;
            this.compiled = false;
        }
    }

    public void preRender() {
        this.heightBuffer = this.bufferHeight / scaledresolution.func_78325_e();
        this.widthBuffer = this.bufferWidth / scaledresolution.func_78325_e();
        GlStateManager.func_179131_c((float)((float)this.red / 255.0f), (float)((float)this.green / 255.0f), (float)((float)this.blue / 255.0f), (float)1.0f);
        GL11.glClearColor((float)((float)this.red / 255.0f), (float)((float)this.green / 255.0f), (float)((float)this.blue / 255.0f), (float)0.0f);
        OpenGlHelper.func_153171_g((int)36160, (int)this.mapFrameBuffer.msFbo);
        GL11.glViewport((int)0, (int)0, (int)this.bufferWidth, (int)this.bufferHeight);
        GlStateManager.func_179086_m((int)16640);
        GlStateManager.func_179098_w();
        RenderHelper.func_74518_a();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)(this.bufferWidth / scaledresolution.func_78325_e()), (double)(this.bufferHeight / scaledresolution.func_78325_e()), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GlStateManager.func_179147_l();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void postRender(float alpha, boolean popup) {
        OpenGlHelper.func_153171_g((int)36008, (int)this.mapFrameBuffer.msFbo);
        OpenGlHelper.func_153171_g((int)36009, (int)this.mapFrameBuffer.fbo);
        GlStateManager.func_179086_m((int)16640);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL30.glBlitFramebuffer((int)0, (int)0, (int)this.bufferWidth, (int)this.bufferHeight, (int)0, (int)0, (int)this.bufferWidth, (int)this.bufferHeight, (int)16384, (int)9728);
        if (popup && ((GuiConfig)this.gui).popupField != null) {
            OpenGlHelper.func_153171_g((int)36160, (int)((GuiConfig)this.gui).popupField.mapFrameBufferContents.msFbo);
            GlStateManager.func_179083_b((int)0, (int)0, (int)((GuiConfig)this.gui).popupField.mapFrameBufferContents.width, (int)((GuiConfig)this.gui).popupField.mapFrameBufferContents.height);
        } else if (this.gui instanceof GuiConfig) {
            if (DefaultSettings.compatibilityMode) {
                if (DefaultSettings.antiAlias) {
                    OpenGlHelper.func_153171_g((int)36160, (int)0);
                } else {
                    FileUtil.MC.func_147110_a().func_147610_a(true);
                }
            } else {
                OpenGlHelper.func_153171_g((int)36160, (int)((GuiConfig)this.gui).framebufferMc.framebuffer);
            }
            GlStateManager.func_179083_b((int)0, (int)0, (int)FileUtil.MC.func_147110_a().field_147621_c, (int)FileUtil.MC.func_147110_a().field_147618_d);
        } else {
            if (DefaultSettings.antiAlias) {
                OpenGlHelper.func_153171_g((int)36160, (int)0);
            } else {
                FileUtil.MC.func_147110_a().func_147610_a(true);
            }
            GlStateManager.func_179083_b((int)0, (int)0, (int)FileUtil.MC.func_147110_a().field_147621_c, (int)FileUtil.MC.func_147110_a().field_147618_d);
        }
        this.compiled = true;
    }

    public void drawTexture(float alpha) {
        int currBound = GL11.glGetInteger((int)32873);
        GlStateManager.func_179144_i((int)this.mapFrameBuffer.texture);
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.posX, (double)this.posY, (double)0.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3d((double)0.0, (double)this.heightBuffer, (double)0.0);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3d((double)this.widthBuffer, (double)this.heightBuffer, (double)0.0);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3d((double)this.widthBuffer, (double)0.0, (double)0.0);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glEnd();
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GlStateManager.func_179144_i((int)currBound);
        GL11.glPopMatrix();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }
}

