/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.ExportSegment;
import de.pt400c.defaultsettings.gui.MathUtil;
import de.pt400c.defaultsettings.gui.RowItem;
import de.pt400c.defaultsettings.gui.ScrollableSegment;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.neptunefx.NEX;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ButtonCheckboxSegment
extends Segment {
    protected final String name;
    public boolean active;
    protected boolean grabbed;
    public float timer = 0.0f;
    private float offX;
    private float offY;
    private final ScrollableSegment parent;

    public ButtonCheckboxSegment(GuiScreen gui, float posX, float posY, float width, float height, String name, boolean popupSegment, ScrollableSegment parent, boolean active) {
        super(gui, posX, posY, width, height, popupSegment);
        this.name = name;
        this.active = active;
        this.parent = parent;
        this.timer = active ? 1.0471976f : 0.0f;
    }

    @Override
    public void customRender(int mouseX, int mouseY, float customPosX, float customPosY, float partialTicks) {
        if (this.active) {
            if (this.timer <= 1.0471976f) {
                this.timer = (float)((double)this.timer + 0.05);
            }
        } else if (this.timer > 0.0f) {
            this.timer = (float)((double)this.timer - 0.05);
        }
        float tempTimer = this.timer;
        if (this.timer > 1.0471976f) {
            tempTimer = 1.0471976f;
        } else if (this.timer < 0.0f) {
            tempTimer = 0.0f;
        }
        float alphaRate = (float)((Math.sin(3.0f * tempTimer - 4.712389f) + 1.0) / 2.0);
        int color = ExportSegment.locked ? -7895161 : -1644826;
        this.offX = customPosX;
        this.offY = customPosY;
        customPosX += this.getPosX();
        customPosY += this.getPosY();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GL11.glBlendFunc((int)770, (int)771);
        float outRad = 3.0f;
        float inRad = 1.0f;
        NEX.drawRectRoundedCorners(customPosX - 2.0f - 3.0f, customPosY - 2.0f - 3.0f, customPosX + this.width + 2.0f + 3.0f, customPosY + this.height + 2.0f + 3.0f, color, outRad);
        float factor = 1.0f - (outRad - inRad) / outRad;
        float innerRadius = outRad - factor * outRad;
        if (this.timer <= 1.0471976f) {
            color = -14145496;
            NEX.drawRectRoundedCorners(customPosX - 2.0f - 3.0f + inRad, customPosY - 2.0f - 3.0f + inRad, customPosX + this.width + 2.0f + 3.0f - inRad, customPosY + this.height + 2.0f + 3.0f - inRad, color, innerRadius < 0.0f ? 0.0f : innerRadius);
        }
        color = -31464;
        int value = (int)(((float)(color >> 24 & 0xFF) / 255.0f - alphaRate) * 255.0f);
        color = (value & 0xFF) << 24 | (color >> 16 & 0xFF & 0xFF) << 16 | (color >> 8 & 0xFF & 0xFF) << 8 | color & 0xFF & 0xFF;
        NEX.drawRectRoundedCorners(customPosX - 2.0f - 3.0f + inRad, customPosY - 2.0f - 3.0f + inRad, customPosX + this.width + 2.0f + 3.0f - inRad, customPosY + this.height + 2.0f + 3.0f - inRad, color, innerRadius < 0.0f ? 0.0f : innerRadius);
        if (this.timer > 0.0f) {
            color = -14145496;
            float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            int scaleFactor = scaledresolution.func_78325_e();
            NEX.drawLine2D_2(f, f1, f2, f3, scaleFactor, 3.0f, new MathUtil.Vec2f(customPosX - 2.0f, customPosY + 1.5f), new MathUtil.Vec2f(customPosX + 4.0f - 3.0f, customPosY + 4.0f + 1.0f), new MathUtil.Vec2f(customPosX + 7.0f - 2.5f, customPosY - 5.0f + 3.0f));
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
    }

    @Override
    public boolean isSelected(int mouseX, int mouseY) {
        float tempX = this.getPosX() + this.offX + this.hitX;
        float tempY = this.getPosY() + this.offY + this.hitY;
        return (((GuiConfig)this.gui).popupField == null || this.getIsPopupSegment()) && (float)mouseX >= tempX - 4.0f && (float)mouseY >= tempY - 4.0f && (float)mouseX < tempX + this.getWidth() + 4.0f && (float)mouseY < tempY + this.getHeight() + 4.0f;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            this.grabbed = true;
            ((DefaultSettingsGUI)this.gui).resetSelected();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
            return false;
        }
        return true;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed) {
            if (this.isSelected(mouseX, mouseY)) {
                this.grabbed = false;
            }
            if (ExportSegment.locked) {
                return false;
            }
            this.active = Boolean.logicalXor(this.active, true);
            FileUtil.switchActive(this.name);
            File fileDir = new File(FileUtil.mcDataDir, "config");
            FileFilter ff = null;
            final String arg = this.parent.searchbar.query;
            ff = arg != null ? new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return !file.getName().equals("defaultsettings") && !file.getName().equals("defaultsettings.json") && !file.getName().equals("ds_dont_export.json") && !file.getName().equals("keys.txt") && !file.getName().equals("options.txt") && !file.getName().equals("optionsof.txt") && !file.getName().equals("servers.dat") && !new File(FileUtil.getMainFolder(), "sharedConfigs/" + file.getName()).exists() && file.getName().toLowerCase().startsWith(arg.toLowerCase());
                }
            } : FileUtil.fileFilter;
            File[] files = fileDir.listFiles(ff);
            List<RowItem> rows = this.parent.list;
            int activeCount = 0;
            for (int i = 0; i < rows.size(); ++i) {
                try {
                    boolean active = FileUtil.mainJson.activeConfigs.contains(files[i].getName());
                    if (!active) continue;
                    ++activeCount;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    activeCount = 0;
                    break;
                }
            }
            this.parent.cache_activity = rows.size() != 0 && activeCount == rows.size() ? (byte)2 : (activeCount > 0 ? (byte)1 : 0);
            this.clickSound();
            return true;
        }
        return false;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
    }
}

