/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.UpdateContainer;
import de.pt400c.defaultsettings.gui.ButtonSegment;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import de.pt400c.defaultsettings.gui.LeftMenu;
import de.pt400c.defaultsettings.gui.MathUtil;
import de.pt400c.neptunefx.NEX;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ButtonUpdateChecker
extends ButtonSegment {
    public float timer = 0.0f;
    private final LeftMenu menu;
    private final Function<GuiConfig, Float> posYF;

    public ButtonUpdateChecker(GuiScreen gui, Function<GuiConfig, Float> posY, LeftMenu menu) {
        super(gui, 0.0f, posY.apply((GuiConfig)gui).floatValue(), null, null, 60, 24, 2);
        this.posYF = posY;
        this.menu = menu;
        if (DefaultSettings.getUpdater().getStatus() == UpdateContainer.Status.ERROR || DefaultSettings.getUpdater().getStatus() == UpdateContainer.Status.UNKNOWN) {
            DefaultSettings.getUpdater().update();
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        if (resized != this.resized_mark) {
            this.posY = this.posYF.apply((GuiConfig)this.gui).floatValue();
            this.resized_mark = resized;
        }
        this.timer = (float)((double)this.timer + 0.05);
        this.width = 60.0f - this.menu.offs;
        float right = this.menu.width - this.menu.offs + this.width - 35.0f + this.menu.offs;
        this.posX = right / 2.0f - this.width / 2.0f;
        float darken = (float)((Math.sin(this.timer - 1.5707964f) + 1.0) / 4.0 + 0.5);
        float inRad = 1.5f;
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GL11.glBlendFunc((int)770, (int)771);
        NEX.drawRectRoundedCorners(this.getPosX(), this.getPosY(), this.getPosX() + this.getWidth(), this.getPosY() + this.getHeight(), NEX.darkenColor(ButtonUpdateChecker.statusToColor(DefaultSettings.getUpdater().getStatus(), darken), 0.5f).getRGB(), 5.0f);
        float factor = 1.0f - (5.0f - inRad) / 5.0f;
        float innerRadius = 5.0f - factor * 5.0f;
        NEX.drawRectRoundedCorners(this.getPosX() + inRad, this.getPosY() + inRad, this.getPosX() + this.width - inRad, this.getPosY() + this.height - inRad, ButtonUpdateChecker.statusToColor(DefaultSettings.getUpdater().getStatus(), darken), innerRadius < 0.0f ? 0.0f : innerRadius);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((6 + (int)(this.menu.offs / 2.8f)) * scaledresolution.func_78325_e()), (int)(5 * scaledresolution.func_78325_e()), (int)((int)((54.0f - this.menu.offs / 0.6f) * (float)scaledresolution.func_78325_e())), (int)(25 * scaledresolution.func_78325_e()));
        float percent = MathUtil.clamp(this.menu.offsetTick / this.menu.maxOffTick, 0.0f, 1.0f);
        GlStateManager.func_179098_w();
        DefaultSettings.fontRenderer.drawString(ButtonUpdateChecker.statusToStr(DefaultSettings.getUpdater().getStatus()), this.posX + this.width / 2.0f - DefaultSettings.fontRenderer.getStringWidth(ButtonUpdateChecker.statusToStr(DefaultSettings.getUpdater().getStatus()), 0.8f, false) / 2.0f - 3.0f, this.getPosY() + 9.0f, NEX.calcAlpha(DefaultSettings.getUpdater().getStatus() != UpdateContainer.Status.OUTDATED ? -1 : -9539986, percent).getRGB(), 0.8f, true);
        GL11.glDisable((int)3089);
        GlStateManager.func_179084_k();
    }

    @Override
    public boolean hoverCheck(int mouseX, int mouseY) {
        String text = ButtonUpdateChecker.statusToIdentifier(DefaultSettings.getUpdater().getStatus());
        if (this.isSelected(mouseX, mouseY) && text != null) {
            ArrayList<String> lines = new ArrayList<String>();
            float textWidth = 0.0f;
            lines.addAll(DefaultSettings.fontRenderer.listFormattedStringToWidth(text, this.gui.field_146294_l - mouseX - 12, true));
            for (String line : lines) {
                if (!(DefaultSettings.fontRenderer.getStringWidth(line, 0.8f, true) > textWidth)) continue;
                textWidth = DefaultSettings.fontRenderer.getStringWidth(line, 0.8f, true);
            }
            NEX.drawButton(mouseX + 5, mouseY - 7 - 10 * lines.size(), (float)(mouseX + 15) + textWidth, mouseY - 3, -12961222, -2302756, 2);
            int offset = 0;
            Collections.reverse(lines);
            for (String line : lines) {
                DefaultSettings.fontRenderer.drawString(line, (float)(mouseX + 9), (float)(mouseY - 14 - offset), -12961222, 0.8f, true);
                offset += 10;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            this.grabbed = true;
            ((DefaultSettingsGUI)this.gui).resetSelected();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseDragged(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed && this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
            DefaultSettings.getUpdater().update();
            this.clickSound();
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public static String statusToIdentifier(UpdateContainer.Status status) {
        switch (status) {
            case CHECKING: {
                return "Checking ...";
            }
            case OUTDATED: {
                return String.format("Your mod version is outdated\nPlease update to %s", DefaultSettings.getUpdater().getOnlineVersion());
            }
            case AHEAD_OF_TIME: {
                return "Heck, you're ahead of reality?!";
            }
            case UP_TO_DATE: {
                return "Up to date";
            }
        }
        return "Something went wrong :(\nWe couldn't check if your\ninstallation is up-to-date";
    }

    public static String statusToStr(UpdateContainer.Status status) {
        switch (status) {
            case CHECKING: {
                return "Checking";
            }
            case OUTDATED: {
                return "Outdated";
            }
            case AHEAD_OF_TIME: {
                return "Beta";
            }
            case UP_TO_DATE: {
                return "Latest";
            }
        }
        return "Error";
    }

    public static int statusToColor(UpdateContainer.Status status, float darken) {
        switch (status) {
            case CHECKING: {
                return NEX.darkenColor(-3158065, darken).getRGB();
            }
            case OUTDATED: {
                return -676831;
            }
            case AHEAD_OF_TIME: {
                return -16218954;
            }
            case UP_TO_DATE: {
                return -13852128;
            }
        }
        return -777456;
    }
}

