/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.neptunefx.NEX;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PopupWindow
extends Segment {
    List<Segment> children = new ArrayList<Segment>();
    public String title;

    public PopupWindow(GuiScreen gui, float posX, float posY, float width, float height, String title) {
        super(gui, posX, posY, width, height, true);
        this.title = title;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        this.posX = 5.0f;
        this.posY = 5.0f;
        NEX.drawRectRoundedUpper(this.posX, this.posY, this.posX + this.width, this.posY + 24.0f, -11513776);
        NEX.drawRectRoundedLower(this.posX, this.posY + 24.0f, this.posX + this.width, this.posY + this.height, -13882324);
        NEX.drawRect(this.posX, this.posY + 24.0f, this.posX + this.width, this.posY + 25.0f, -12895429, true, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderContents(int mouseX, int mouseY, float partialTicks) {
        DefaultSettings.fontRenderer.drawString(this.title, this.getPosX() + this.getWidth() / 2.0f + 1.0f - DefaultSettings.fontRenderer.getStringWidth(this.title, 1.1f, true) / 2.0f, this.getPosY() + 8.0f, -328966, 1.1f, true);
        List<Segment> list = this.children;
        synchronized (list) {
            this.children.forEach(segment -> segment.render(mouseX, mouseY, partialTicks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hoverChecks(int mouseX, int mouseY) {
        List<Segment> list = this.children;
        synchronized (list) {
            this.children.forEach(segment -> segment.hoverCheck(mouseX, mouseY));
        }
    }

    @Override
    public boolean isSelected(int mouseX, int mouseY) {
        return (float)mouseX >= this.getPosX() && (float)mouseY >= this.getPosY() + 10.0f && (float)mouseX < this.getPosX() + this.getWidth() && (float)mouseY < this.getPosY() + 24.0f || (float)mouseX >= this.getPosX() + 10.0f && (float)mouseY >= this.getPosY() && (float)mouseX < this.getPosX() + this.getWidth() - 10.0f && (float)mouseY < this.getPosY() + 10.0f || NEX.distanceBetweenPoints(this.getPosX() + 10.0f, this.getPosY() + 10.0f, mouseX, mouseY) <= 10.0f || NEX.distanceBetweenPoints(this.getPosX() + this.getWidth() - 10.0f, this.getPosY() + 10.0f, mouseX, mouseY) <= 10.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        List<Segment> list = this.children;
        synchronized (list) {
            for (Segment segment : this.children) {
                if (!segment.mouseClicked(mouseX, mouseY, mouseButton)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean keyTyped(char typedChar, int keyCode) {
        List<Segment> list = this.children;
        synchronized (list) {
            for (Segment segment : this.children) {
                if (segment.keyTyped(typedChar, keyCode)) break;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mouseDragged(int p_mouseDragged_1_, int p_mouseDragged_3_, int p_mouseDragged_5_) {
        List<Segment> list = this.children;
        synchronized (list) {
            for (Segment segment : this.children) {
                if (segment.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_)) break;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mouseReleased(int p_mouseReleased_1_, int p_mouseReleased_3_, int p_mouseReleased_5_) {
        List<Segment> list = this.children;
        synchronized (list) {
            for (Segment segment : this.children) {
                if (!segment.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PopupWindow addChild(Segment segment) {
        List<Segment> list = this.children;
        synchronized (list) {
            float offX = ((GuiConfig)this.gui).popupField == null ? 0.0f : ((GuiConfig)this.gui).popupField.popX;
            float offY = ((GuiConfig)this.gui).popupField == null ? 0.0f : ((GuiConfig)this.gui).popupField.popY;
            this.children.add(segment.setPosHit(5.0f + segment.posX, 5.0f + segment.posY, offX, offY));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearChildren() {
        ((GuiConfig)this.gui).popupField.reset();
        List<Segment> list = this.children;
        synchronized (list) {
            this.children.clear();
        }
    }

    public List<Segment> getChildren() {
        return this.children;
    }
}

