/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.GuiConfig;
import de.pt400c.defaultsettings.gui.MathUtil;
import de.pt400c.defaultsettings.gui.MenuScreen;
import de.pt400c.defaultsettings.gui.ScrollableSegment;
import de.pt400c.defaultsettings.gui.Segment;
import de.pt400c.neptunefx.NEX;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SearchbarSegment
extends Segment {
    protected boolean grabbed;
    public String query = "";
    protected boolean focused = false;
    private int cursorTimer = 0;
    boolean activated;
    private float flashingTimer = 0.0f;
    private final ResourceLocation icon;
    int cursorPosition;
    protected final ScrollableSegment parent;
    private static final String chars = "@^\u00b0\"\u00a7$%&/()=?`\u00b4\\#+*'-}][{-_~";

    public SearchbarSegment(GuiScreen gui, float posX, float posY, int width, int height, boolean popupSegment, ScrollableSegment parent) {
        super(gui, posX, posY, width, height, popupSegment);
        this.parent = parent;
        this.icon = new ResourceLocation("defaultsettings", "textures/gui/glass.png");
    }

    public static boolean isAllowedCharacter(char character) {
        return character != '\u00a7' && character >= ' ' && character != '\u007f' && chars.indexOf(character) == -1;
    }

    @Override
    protected boolean keyTyped(char typedChar, int keyCode) {
        if (SearchbarSegment.isAllowedCharacter(typedChar)) {
            String s1 = ChatAllowedCharacters.func_71565_a((String)Character.toString(typedChar));
            if (this.query.isEmpty() && s1.equals(" ")) {
                return true;
            }
            if (this.query.length() > 30) {
                return false;
            }
            String left = this.query.substring(0, this.cursorPosition);
            String right = this.query.substring(this.cursorPosition);
            ++this.cursorPosition;
            this.query = left + s1 + right;
            this.activated = false;
            return true;
        }
        if (keyCode == 14) {
            if (this.query.length() < 1 || this.cursorPosition < 1) {
                return false;
            }
            String left = this.query.substring(0, this.cursorPosition);
            String right = this.query.substring(this.cursorPosition);
            left = left.substring(0, left.length() - 1);
            if (this.cursorPosition > 0) {
                --this.cursorPosition;
            }
            this.query = left + right;
            this.activated = false;
            return true;
        }
        if (keyCode == 203) {
            this.cursorPosition = MathUtil.clamp(this.cursorPosition - 1, 0, this.query.length());
            return true;
        }
        if (keyCode == 205) {
            this.cursorPosition = MathUtil.clamp(this.cursorPosition + 1, 0, this.query.length());
            return true;
        }
        if (keyCode == 28 || keyCode == 156) {
            if (!this.query.isEmpty()) {
                this.activated = true;
            }
            this.sendQuery();
            return true;
        }
        return false;
    }

    private void sendQuery() {
        this.parent.add = 0.0f;
        this.parent.guiContentUpdate(this.query);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GL11.glBlendFunc((int)770, (int)771);
        this.flashingTimer = (float)((double)this.flashingTimer + 0.07);
        float darken = (float)((Math.sin(this.flashingTimer - 1.5707964f) + 1.0) / 4.0 + 0.5);
        int color = 0;
        this.width = MathUtil.clamp(DefaultSettings.fontRenderer.getStringWidth(this.query, 1.0f, false) + 15.0f, 40.0f, (float)(this.gui.field_146294_l - 180));
        String text = this.query;
        float dots = DefaultSettings.fontRenderer.getStringWidth("...", 1.0f, false);
        float widthString = DefaultSettings.fontRenderer.getStringWidth(text, 1.0f, false);
        if (widthString >= (float)(this.gui.field_146294_l - 190)) {
            text = DefaultSettings.fontRenderer.trimStringToWidth(text, (int)((float)(this.gui.field_146294_l - 190 - 1) - dots), false) + "...";
        }
        MenuScreen menu = ((GuiConfig)this.gui).menu;
        this.focused = menu.getVariants().get((int)menu.index).selected == this;
        float diff = this.focused ? 1.5f : 1.0f;
        NEX.drawRectRoundedCorners(this.getPosX() - diff, this.getPosY() - diff, this.getPosX() + this.getWidth() + diff, this.getPosY() + this.getHeight() + diff, -1644826, 2.1474836E9f);
        NEX.drawRectRoundedCorners(this.getPosX(), this.getPosY(), this.getPosX() + this.getWidth(), this.getPosY() + this.getHeight(), -12829636, 2.1474836E9f);
        GlStateManager.func_179098_w();
        FileUtil.MC.func_110434_K().func_110577_a(this.icon);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        NEX.drawScaledTex(this.getPosX() - 18.0f, this.getPosY() + 2.0f, 15, 15);
        GlStateManager.func_179090_x();
        ++this.cursorTimer;
        if (this.cursorTimer > 80) {
            this.cursorTimer = 0;
        }
        if (this.cursorTimer <= 40 && this.focused) {
            color = -6250336;
            float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
            NEX.drawRect(this.getPosX() + 5.0f + DefaultSettings.fontRenderer.getStringWidth(text.substring(0, this.cursorPosition), 1.0f, false), this.getPosY() + 4.0f, this.getPosX() + 5.5f + DefaultSettings.fontRenderer.getStringWidth(text.substring(0, this.cursorPosition), 1.0f, false), this.getPosY() + this.getHeight() - 4.0f, null, false, null, false);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        if (this.query.isEmpty()) {
            DefaultSettings.fontRenderer.drawString("Query", this.getPosX() + 5.0f, this.getPosY() + 5.0f, this.focused && !this.activated ? NEX.darkenColor(-1644826, darken).getRGB() : -1644826, 1.0f, false);
        } else {
            DefaultSettings.fontRenderer.drawString(text, this.getPosX() + 5.0f, this.getPosY() + 5.0f, -1644826, 1.0f, false);
        }
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            MenuScreen menu = ((GuiConfig)this.gui).menu;
            menu.getVariants().get((int)menu.index).selected = this;
            this.grabbed = true;
            if (this.query.isEmpty()) {
                return true;
            }
            this.cursorPosition = DefaultSettings.fontRenderer.trimStringToWidth(this.query, (int)((float)mouseX - (this.getPosX() + this.hitX + 5.0f)), false).length();
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        if (!this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseDragged(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.grabbed && this.isSelected(mouseX, mouseY)) {
            this.grabbed = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

