/*
 * Decompiled with CFR 0.152.
 */
package de.pt400c.defaultsettings.gui;

import de.pt400c.defaultsettings.DefaultSettings;
import de.pt400c.defaultsettings.FileUtil;
import de.pt400c.defaultsettings.gui.DefaultSettingsGUI;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class Segment {
    protected final GuiScreen gui;
    protected float posX;
    protected float posY;
    protected float width;
    protected float height;
    protected float hitX;
    protected float hitY;
    protected final boolean isPopupSegment;
    public static ScaledResolution scaledresolution;
    public static int resized;
    protected int resized_mark = 0;

    public Segment(GuiScreen gui, float posX, float posY, float width, float height, boolean popupSegment) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
        this.width = width;
        this.height = height;
        this.isPopupSegment = popupSegment;
    }

    public abstract void render(int var1, int var2, float var3);

    public void customRender(int mouseX, int mouseY, float customPosX, float customPosY, float partialTicks) {
    }

    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return this.isSelected(mouseX, mouseY);
    }

    public boolean hoverCheck(int mouseX, int mouseY) {
        return false;
    }

    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        return this.isSelected(mouseX, mouseY);
    }

    public boolean handleMouseInput() {
        int mouseX = (int)((float)Mouse.getEventX() * this.width / (float)FileUtil.MC.field_71443_c);
        int mouseY = (int)(this.height - (float)Mouse.getEventY() * this.height / (float)FileUtil.MC.field_71440_d - 1.0f);
        return this.isSelected(mouseX, mouseY);
    }

    protected boolean keyTyped(char typedChar, int keyCode) {
        return false;
    }

    public boolean mouseDragged(int mouseX, int mouseY, int button) {
        return this.isSelected(mouseX, mouseY);
    }

    public boolean isSelected(int mouseX, int mouseY) {
        return (((DefaultSettingsGUI)this.gui).popupField == null || this.getIsPopupSegment()) && (float)mouseX >= this.getPosX() + this.hitX && (float)mouseY >= this.getPosY() + this.hitY && (float)mouseX < this.getPosX() + this.hitX + this.getWidth() && (float)mouseY < this.getPosY() + this.hitY + this.getHeight();
    }

    public float getPosX() {
        return this.posX;
    }

    public float getPosY() {
        return this.posY;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public boolean getIsPopupSegment() {
        return this.isPopupSegment;
    }

    public void initSegment() {
    }

    public void init() {
    }

    public void guiContentUpdate(String ... arg) {
    }

    public Segment setPos(float x, float y) {
        this.posX = x;
        this.posY = y;
        return this;
    }

    public Segment setPosHit(float x, float y, float x2, float y2) {
        this.posX = x;
        this.posY = y;
        this.hitX = x2;
        this.hitY = y2;
        return this;
    }

    public void clickSound() {
        if (DefaultSettings.mcVersion.startsWith("1.8")) {
            FileUtil.MC.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
        } else {
            FileUtil.MC.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    static {
        resized = 0;
    }
}

