/*
 * Decompiled with CFR 0.152.
 */
package kaptainwutax.memorytester.gui;

import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import kaptainwutax.memorytester.data.DataConfig;
import kaptainwutax.memorytester.init.InitData;
import kaptainwutax.memorytester.thread.ThreadMain;
import org.apache.commons.io.FileUtils;

public class GuiErrorCrash {
    private ThreadMain threadInstance;
    public JFrame frame;
    public JLabel crash;
    public JLabel crashInfo;

    public GuiErrorCrash(ThreadMain threadInstance) {
        this.threadInstance = threadInstance;
        this.initialize();
    }

    private void initialize() {
        this.frame = new JFrame();
        this.frame.setBounds(0, 0, Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height);
        this.frame.setTitle("Memory Tester");
        this.frame.setDefaultCloseOperation(2);
        this.frame.getContentPane().setLayout(null);
        this.frame.setExtendedState(6);
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent arg0) {
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                ((GuiErrorCrash)GuiErrorCrash.this).threadInstance.shouldGameStart = false;
                GuiErrorCrash.this.frame.setEnabled(false);
                GuiErrorCrash.this.frame.setVisible(false);
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
            }

            @Override
            public void windowOpened(WindowEvent arg0) {
            }
        });
        int textWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int textCenterX = this.frame.getWidth() / 2 - textWidth / 2;
        int textOffsetX = 0;
        int textHeight = 40;
        int textCenterY = this.frame.getHeight() / 2 - textHeight / 2;
        int textOffsetY = -400;
        this.crash = new JLabel("loading...");
        this.crash.setFont(new Font("Yu Gothic UI Light", 0, 30));
        this.crash.setHorizontalAlignment(0);
        this.crash.setBounds(textCenterX + textOffsetX, textCenterY + textOffsetY, textWidth, textHeight);
        this.frame.getContentPane().add(this.crash);
        this.crashInfo = new JLabel("loading...");
        this.crashInfo.setFont(new Font("Yu Gothic UI Light", 0, 30));
        this.crashInfo.setHorizontalAlignment(0);
        this.crashInfo.setBounds(textCenterX + textOffsetX, textCenterY + textOffsetY + 60, textWidth, textHeight);
        this.frame.getContentPane().add(this.crashInfo);
        int buttonWidth = 500;
        int buttonCenterX = this.frame.getWidth() / 2 - buttonWidth / 2;
        int buttonOffsetX = 0;
        int buttonHeight = 40;
        int buttonCenterY = this.frame.getHeight() / 2 - buttonHeight / 2;
        int buttonOffsetY = -250;
        JButton resetButton = new JButton("Reset Config");
        resetButton.setEnabled(true);
        resetButton.setBounds(buttonCenterX + buttonOffsetX, buttonCenterY + buttonOffsetY, buttonWidth, buttonHeight);
        this.frame.getContentPane().add(resetButton);
        resetButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                GuiErrorCrash.this.crash.setText("Generating Resources");
                GuiErrorCrash.this.crashInfo.setText("Resetting config files");
                GuiErrorCrash.this.frame.update(GuiErrorCrash.this.frame.getGraphics());
                try {
                    FileUtils.forceDelete((File)new File("config/MemoryTester"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                for (DataConfig config : InitData.configs) {
                    config.setDefaultDataToThread();
                    config.resetFile();
                }
                DataConfig.generateResources(GuiErrorCrash.this.threadInstance);
                ((GuiErrorCrash)GuiErrorCrash.this).threadInstance.shouldGameStart = false;
                GuiErrorCrash.this.frame.setEnabled(false);
                GuiErrorCrash.this.frame.setVisible(false);
                GuiErrorCrash.this.frame.dispose();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        JButton quitButton = new JButton("Quit");
        quitButton.setEnabled(true);
        quitButton.setBounds(buttonCenterX + buttonOffsetX, buttonCenterY + buttonOffsetY + 50, buttonWidth, buttonHeight);
        this.frame.getContentPane().add(quitButton);
        quitButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ((GuiErrorCrash)GuiErrorCrash.this).threadInstance.shouldGameStart = false;
                GuiErrorCrash.this.frame.setEnabled(false);
                GuiErrorCrash.this.frame.setVisible(false);
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
    }
}

