/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.energy.BCEnergyFluids;
import buildcraft.energy.client.sprite.AtlasSpriteFluid;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.fluid.BCFluid;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BCEnergySprites {
    public static void fmlPreInit() {
        MinecraftForge.EVENT_BUS.register(BCEnergySprites.class);
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        TextureMap map = event.getMap();
        if (!BCLibConfig.useSwappableSprites) {
            for (BCFluid f : BCEnergyFluids.allFluids) {
                map.func_174942_a(f.getStill());
                map.func_174942_a(f.getFlowing());
            }
            return;
        }
        ResourceLocation[][] fromSprites = new ResourceLocation[3][2];
        for (int h = 0; h < 3; ++h) {
            fromSprites[h][0] = new ResourceLocation("buildcraftenergy:blocks/fluids/heat_" + h + "_still");
            fromSprites[h][1] = new ResourceLocation("buildcraftenergy:blocks/fluids/heat_" + h + "_flow");
        }
        for (BCFluid f : BCEnergyFluids.allFluids) {
            ResourceLocation[] sprites = fromSprites[f.getHeatValue()];
            map.setTextureEntry((TextureAtlasSprite)new AtlasSpriteFluid(f.getStill().toString(), sprites[0], f));
            map.setTextureEntry((TextureAtlasSprite)new AtlasSpriteFluid(f.getFlowing().toString(), sprites[1], f));
        }
    }
}

