/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.event;

import buildcraft.api.core.BCLog;
import buildcraft.energy.BCEnergyConfig;
import buildcraft.energy.BCEnergyFluids;
import buildcraft.lib.fluid.BCFluid;
import java.lang.reflect.Field;
import java.time.Month;
import java.time.MonthDay;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.util.text.translation.LanguageMap;

public class ChristmasHandler {
    private static Boolean enabled;

    public static boolean isEnabled() {
        if (enabled == null) {
            throw new IllegalStateException("Unknown until init!");
        }
        return enabled;
    }

    private static void fmlPreInit() {
        enabled = BCEnergyConfig.christmasEventStatus.isEnabled(MonthDay.of(Month.DECEMBER, 25));
        if (ChristmasHandler.isEnabled()) {
            ChristmasHandler.setColours(12612916, 5905676, BCEnergyFluids.crudeOil);
            ChristmasHandler.setColours(13926969, 14187827, BCEnergyFluids.oilResidue);
            ChristmasHandler.setColours(13926969, 5905676, BCEnergyFluids.oilHeavy);
            ChristmasHandler.setColours(13926969, 3149317, BCEnergyFluids.oilDense);
            ChristmasHandler.setColours(12612916, 9059612, BCEnergyFluids.oilDistilled);
            ChristmasHandler.setColours(5190447, 3149317, BCEnergyFluids.fuelDense);
            ChristmasHandler.setColours(8930349, 5905676, BCEnergyFluids.fuelMixedHeavy);
            ChristmasHandler.setColours(10182969, 9722161, BCEnergyFluids.fuelLight);
            ChristmasHandler.setColours(12612916, 11757612, BCEnergyFluids.fuelMixedLight);
            ChristmasHandler.setColours(14076304, 13614990, BCEnergyFluids.fuelGaseous);
        }
    }

    public static void fmlPreInitDedicatedServer() {
        ChristmasHandler.fmlPreInit();
        if (ChristmasHandler.isEnabled()) {
            ChristmasHandler.replaceLangEntries();
        }
    }

    public static void fmlPreInitClient() {
        ChristmasHandler.fmlPreInit();
        if (ChristmasHandler.isEnabled()) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(m -> ChristmasHandler.replaceLangEntries());
        }
    }

    private static void setColours(int lightColour, int darkColour, BCFluid[] fluids) {
        if (fluids != null) {
            for (BCFluid fluid : fluids) {
                fluid.setColour(lightColour, darkColour);
                if (fluid.isGaseous()) {
                    fluid.setGaseous(false);
                }
                if (fluid.getDensity() >= 0) continue;
                fluid.setDensity(-fluid.getDensity());
            }
        }
    }

    private static void replaceLangEntries() {
        try {
            ChristmasHandler.replaceLangEntries0();
        }
        catch (ReflectiveOperationException e) {
            BCLog.logger.warn("[energy.christmas] Unable to replace language entries! Did something change?", (Throwable)e);
        }
    }

    private static void replaceLangEntries0() throws ReflectiveOperationException {
        Class<LanguageMap> cls = LanguageMap.class;
        Field fldInstance = null;
        Field fldLangMap = null;
        for (Field fld : cls.getDeclaredFields()) {
            if (fld.getType() == cls) {
                if (fldInstance == null) {
                    fldInstance = fld;
                    continue;
                }
                throw new ReflectiveOperationException("Found duplicate fields for instance! (" + fldInstance + " and " + fld + ")");
            }
            if (fld.getType() != Map.class) continue;
            if (fldLangMap == null) {
                fldLangMap = fld;
                continue;
            }
            throw new ReflectiveOperationException("Found duplicate fields for langMap! (" + fldLangMap + " and " + fld + ")");
        }
        if (fldInstance == null) {
            throw new ReflectiveOperationException("Couln't find the instance field!");
        }
        if (fldLangMap == null) {
            throw new ReflectiveOperationException("Couln't find the map field!");
        }
        fldInstance.setAccessible(true);
        fldLangMap.setAccessible(true);
        LanguageMap instance = (LanguageMap)fldInstance.get(null);
        ChristmasHandler.checkAndReplaceEntries((Map)fldLangMap.get(instance));
        fldInstance.setAccessible(false);
        fldLangMap.setAccessible(false);
    }

    private static <K, V> void checkAndReplaceEntries(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V altValue = map.get("buildcraft.christmas." + key);
            if (altValue == null) continue;
            entry.setValue(altValue);
        }
    }
}

