/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.cap;

import buildcraft.api.core.EnumPipePart;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class CapabilityHelper
implements ICapabilityProvider {
    private final Map<EnumPipePart, Map<Capability<?>, Supplier<?>>> caps = new EnumMap(EnumPipePart.class);
    private final List<ICapabilityProvider> additional = new ArrayList<ICapabilityProvider>();

    public CapabilityHelper() {
        for (EnumPipePart face : EnumPipePart.VALUES) {
            this.caps.put(face, new HashMap());
        }
    }

    private Map<Capability<?>, Supplier<?>> getCapMap(EnumFacing facing) {
        return this.caps.get((Object)EnumPipePart.fromFacing(facing));
    }

    public <T> void addCapabilityInstance(@Nullable Capability<T> cap, T instance, EnumPipePart ... parts) {
        Supplier<Object> supplier = () -> instance;
        this.addCapability(cap, supplier, parts);
    }

    public <T> void addCapability(@Nullable Capability<T> cap, Supplier<T> getter, EnumPipePart ... parts) {
        if (cap == null) {
            return;
        }
        for (EnumPipePart part : parts) {
            this.caps.get((Object)part).put(cap, getter);
        }
    }

    public <T> void addCapability(@Nullable Capability<T> cap, Function<EnumFacing, T> getter, EnumPipePart ... parts) {
        if (cap == null) {
            return;
        }
        for (EnumPipePart part : parts) {
            this.caps.get((Object)part).put(cap, () -> getter.apply(part.face));
        }
    }

    public <T extends ICapabilityProvider> T addProvider(T provider) {
        if (provider != null) {
            this.additional.add(provider);
        }
        return provider;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        Map<Capability<?>, Supplier<?>> capMap = this.getCapMap(facing);
        Supplier<?> supplier = capMap.get(capability);
        if (supplier != null) {
            return (T)supplier.get();
        }
        for (ICapabilityProvider provider : this.additional) {
            if (!provider.hasCapability(capability, facing)) continue;
            return (T)provider.getCapability(capability, facing);
        }
        return null;
    }
}

