/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.fluid;

import buildcraft.lib.fluid.Tank;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TankProperties
implements IFluidTankProperties {
    private final Tank tank;
    private final boolean canFill;
    private final boolean canDrain;

    public TankProperties(Tank tank, boolean canFill, boolean canDrain) {
        this.tank = tank;
        this.canFill = canFill;
        this.canDrain = canDrain;
    }

    public FluidStack getContents() {
        FluidStack current = this.tank.getFluid();
        return current == null ? null : current.copy();
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public boolean canFill() {
        return this.canFill;
    }

    public boolean canDrain() {
        return this.canDrain;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        return this.canFill() && this.tank.canFillFluidType(fluidStack);
    }

    public boolean canDrainFluidType(FluidStack fluidStack) {
        return this.canDrain();
    }
}

