/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.config;

import buildcraft.api.core.BCLog;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.gui.config.GuiConfigEntry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.TreeMap;

class GuiConfigSet {
    final Map<String, GuiConfigEntry> properties = new TreeMap<String, GuiConfigEntry>();

    GuiConfigSet() {
    }

    IVariableNode getOrAddProperty(String name, IExpressionNode value) {
        return this.properties.computeIfAbsent(name, GuiConfigEntry::new).getOrAdd(value);
    }

    JsonObject writeToJson() {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, GuiConfigEntry> entry : this.properties.entrySet()) {
            String name = entry.getKey();
            GuiConfigEntry value = entry.getValue();
            json.add(name, (JsonElement)value.writeToJson());
        }
        return json;
    }

    void readFromJson(JsonObject json) {
        for (Map.Entry entry : json.entrySet()) {
            JsonElement elem;
            String name = (String)entry.getKey();
            GuiConfigEntry guiEntry = this.properties.get(name);
            if (guiEntry == null) {
                guiEntry = new GuiConfigEntry(name);
                this.properties.put(name, guiEntry);
            }
            if (!(elem = (JsonElement)entry.getValue()).isJsonObject()) {
                BCLog.logger.warn("[lib.gui.config] Found a non-object element in '" + name + "'");
                continue;
            }
            guiEntry.readFromJson(elem.getAsJsonObject());
        }
    }
}

