/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.nbt;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.lib.nbt.WrittenType;
import gnu.trove.list.array.TByteArrayList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.list.array.TShortArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NbtSquishMap {
    final TByteArrayList bytes = new TByteArrayList();
    final TShortArrayList shorts = new TShortArrayList();
    final TIntArrayList ints = new TIntArrayList();
    final TLongArrayList longs = new TLongArrayList();
    final TFloatArrayList floats = new TFloatArrayList();
    final TDoubleArrayList doubles = new TDoubleArrayList();
    final List<TByteArrayList> byteArrays = new ArrayList<TByteArrayList>();
    final List<TIntArrayList> intArrays = new ArrayList<TIntArrayList>();
    final List<String> strings = new ArrayList<String>();
    final List<NBTBase> complex = new ArrayList<NBTBase>();

    public void addTag(NBTBase nbt) {
        if (nbt instanceof NBTTagString) {
            String val = ((NBTTagString)nbt).func_150285_a_();
            if (!this.strings.contains(val)) {
                this.strings.add(val);
            }
        } else if (nbt instanceof NBTTagByte) {
            byte val = ((NBTTagByte)nbt).func_150290_f();
            if (!this.bytes.contains(val)) {
                this.bytes.add(val);
            }
        } else if (nbt instanceof NBTTagShort) {
            short val = ((NBTTagShort)nbt).func_150289_e();
            if (!this.shorts.contains(val)) {
                this.shorts.add(val);
            }
        } else if (nbt instanceof NBTTagInt) {
            int val = ((NBTTagInt)nbt).func_150287_d();
            if (!this.ints.contains(val)) {
                this.ints.add(val);
            }
        } else if (nbt instanceof NBTTagLong) {
            long val = ((NBTTagLong)nbt).func_150291_c();
            if (!this.longs.contains(val)) {
                this.longs.add(val);
            }
        } else if (nbt instanceof NBTTagFloat) {
            float val = ((NBTTagFloat)nbt).func_150288_h();
            if (!this.floats.contains(val)) {
                this.floats.add(val);
            }
        } else if (nbt instanceof NBTTagDouble) {
            double val = ((NBTTagDouble)nbt).func_150286_g();
            if (!this.doubles.contains(val)) {
                this.doubles.add(val);
            }
        } else if (nbt instanceof NBTTagByteArray) {
            byte[] val = ((NBTTagByteArray)nbt).func_150292_c();
            TByteArrayList array = new TByteArrayList(val);
            if (!this.byteArrays.contains(array)) {
                this.byteArrays.add(array);
            }
        } else if (nbt instanceof NBTTagIntArray) {
            int[] val = ((NBTTagIntArray)nbt).func_150302_c();
            TIntArrayList array = new TIntArrayList(val);
            if (!this.intArrays.contains(array)) {
                this.intArrays.add(array);
            }
        } else if (nbt instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)nbt;
            if (!this.complex.contains(list)) {
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    this.addTag(list.func_179238_g(i));
                }
                this.complex.add((NBTBase)list);
            }
        } else if (nbt instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            if (!this.complex.contains(compound)) {
                for (String key : compound.func_150296_c()) {
                    if (!this.strings.contains(key)) {
                        this.strings.add(key);
                    }
                    this.addTag(compound.func_74781_a(key));
                }
                this.complex.add((NBTBase)compound);
            }
        } else {
            throw new IllegalArgumentException("Cannot handle tag " + nbt);
        }
    }

    public int indexOfTag(NBTBase nbt) {
        int offset = 0;
        if (nbt instanceof NBTTagByte) {
            return this.bytes.indexOf(((NBTTagByte)nbt).func_150290_f());
        }
        offset += this.bytes.size();
        if (nbt instanceof NBTTagShort) {
            return offset + this.shorts.indexOf(((NBTTagShort)nbt).func_150289_e());
        }
        offset += this.shorts.size();
        if (nbt instanceof NBTTagInt) {
            return offset + this.ints.indexOf(((NBTTagInt)nbt).func_150287_d());
        }
        offset += this.ints.size();
        if (nbt instanceof NBTTagLong) {
            return offset + this.longs.indexOf(((NBTTagLong)nbt).func_150291_c());
        }
        offset += this.longs.size();
        if (nbt instanceof NBTTagFloat) {
            return offset + this.floats.indexOf(((NBTTagFloat)nbt).func_150288_h());
        }
        offset += this.floats.size();
        if (nbt instanceof NBTTagDouble) {
            return offset + this.doubles.indexOf(((NBTTagDouble)nbt).func_150286_g());
        }
        offset += this.doubles.size();
        if (nbt instanceof NBTTagByteArray) {
            byte[] val = ((NBTTagByteArray)nbt).func_150292_c();
            TByteArrayList array = new TByteArrayList(val);
            return offset + this.byteArrays.indexOf(array);
        }
        offset += this.byteArrays.size();
        if (nbt instanceof NBTTagIntArray) {
            int[] val = ((NBTTagIntArray)nbt).func_150302_c();
            TIntArrayList array = new TIntArrayList(val);
            return offset + this.intArrays.indexOf(array);
        }
        offset += this.intArrays.size();
        if (nbt instanceof NBTTagString) {
            return offset + this.strings.indexOf(((NBTTagString)nbt).func_150285_a_());
        }
        offset += this.strings.size();
        if (nbt instanceof NBTTagList) {
            return offset + this.complex.indexOf(nbt);
        }
        if (nbt instanceof NBTTagCompound) {
            return offset + this.complex.indexOf(nbt);
        }
        throw new IllegalArgumentException("Cannot handle tag " + nbt);
    }

    private NBTBase getTagAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " was less than 0!");
        }
        if (index < this.bytes.size()) {
            return new NBTTagByte(this.bytes.get(index));
        }
        if ((index -= this.bytes.size()) < this.shorts.size()) {
            return new NBTTagShort(this.shorts.get(index));
        }
        if ((index -= this.shorts.size()) < this.ints.size()) {
            return new NBTTagInt(this.ints.get(index));
        }
        if ((index -= this.ints.size()) < this.longs.size()) {
            return new NBTTagLong(this.longs.get(index));
        }
        if ((index -= this.longs.size()) < this.floats.size()) {
            return new NBTTagFloat(this.floats.get(index));
        }
        if ((index -= this.floats.size()) < this.doubles.size()) {
            return new NBTTagDouble(this.doubles.get(index));
        }
        if ((index -= this.doubles.size()) < this.byteArrays.size()) {
            return new NBTTagByteArray(this.byteArrays.get(index).toArray());
        }
        if ((index -= this.byteArrays.size()) < this.intArrays.size()) {
            return new NBTTagIntArray(this.intArrays.get(index).toArray());
        }
        if ((index -= this.intArrays.size()) < this.strings.size()) {
            return new NBTTagString(this.strings.get(index));
        }
        if ((index -= this.strings.size()) < this.complex.size()) {
            return this.complex.get(index);
        }
        index -= this.complex.size();
        return null;
    }

    public NBTBase getTagForWriting(int index) {
        NBTBase value = this.getTagAt(index);
        if (value == null) {
            throw new IllegalArgumentException("Cannot handle index " + index);
        }
        return value;
    }

    public NBTBase getTagForReading(int index) throws IOException {
        try {
            NBTBase value = this.getTagAt(index);
            if (value == null) {
                throw new IOException("Cannot handle index " + index);
            }
            return value;
        }
        catch (IndexOutOfBoundsException e) {
            throw new InvalidInputDataException(e);
        }
    }

    public NBTTagCompound getFullyReadComp(int index) throws IOException {
        NBTBase tag = this.getTagForReading(index);
        if (tag instanceof NBTTagCompound) {
            return (NBTTagCompound)tag;
        }
        throw new IOException("The tag at " + index + " was not a compound tag! (was " + tag + ")");
    }

    public String getStringForReading(int index) throws IOException {
        if (index < 0 || index >= this.strings.size()) {
            throw new IOException("Cannot handle index " + index);
        }
        return this.strings.get(index);
    }

    public int sizeOf(int tagType) {
        return this.size(1 << tagType - 1);
    }

    public int size(int typeFlags) {
        int total = 0;
        if (NbtSquishMap.isFlag(typeFlags, 1)) {
            total += this.bytes.size();
        }
        if (NbtSquishMap.isFlag(typeFlags, 2)) {
            total += this.shorts.size();
        }
        if (NbtSquishMap.isFlag(typeFlags, 3)) {
            total += this.ints.size();
        }
        if (NbtSquishMap.isFlag(typeFlags, 4)) {
            total += this.longs.size();
        }
        if (NbtSquishMap.isFlag(typeFlags, 5)) {
            total += this.floats.size();
        }
        if (NbtSquishMap.isFlag(typeFlags, 6)) {
            total += this.doubles.size();
        }
        if (NbtSquishMap.isFlag(typeFlags, 7)) {
            total += this.byteArrays.size();
        }
        if (NbtSquishMap.isFlag(typeFlags, 11)) {
            total += this.intArrays.size();
        }
        if (NbtSquishMap.isFlag(typeFlags, 8)) {
            total += this.strings.size();
        }
        if (NbtSquishMap.isFlag(typeFlags, 10)) {
            total += this.complex.size();
        } else if (NbtSquishMap.isFlag(typeFlags, 9)) {
            total += this.complex.size();
        }
        return total;
    }

    private static boolean isFlag(int flags, int val) {
        int flag = 1 << val;
        return (flags & flag) == flag;
    }

    public int size() {
        return this.size(-1);
    }

    public WrittenType getWrittenType() {
        return WrittenType.getForSize(this.size());
    }

    public int stringSize() {
        return this.strings.size();
    }
}

