/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net.cache;

import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.net.cache.NetworkedObjectCache;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class NetworkedItemStackCache
extends NetworkedObjectCache<ItemStack> {
    public NetworkedItemStackCache() {
        super(StackUtil.EMPTY);
    }

    @Override
    protected Object2IntMap<ItemStack> createObject2IntMap() {
        return new Object2IntOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<ItemStack>(){

            public int hashCode(ItemStack o) {
                if (o == null || o.func_190926_b()) {
                    return 0;
                }
                return Objects.hash(o.func_77973_b(), o.func_77978_p());
            }

            public boolean equals(ItemStack a, ItemStack b) {
                if (a == null || b == null) {
                    return a == b;
                }
                return StackUtil.canMerge(a, b);
            }
        });
    }

    @Override
    protected ItemStack copyOf(ItemStack object) {
        return object == null ? null : object.func_77946_l();
    }

    @Override
    protected void writeObject(ItemStack obj, PacketBufferBC buffer) {
        if (obj == null || obj.func_190926_b()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.writeShort(Item.func_150891_b((Item)obj.func_77973_b()));
            buffer.writeShort(obj.func_77960_j());
            NBTTagCompound tag = null;
            if (obj.func_77973_b().func_77645_m() || obj.func_77973_b().func_77651_p()) {
                tag = obj.func_77973_b().getNBTShareTag(obj);
            }
            buffer.func_150786_a(tag);
        }
    }

    @Override
    protected ItemStack readObject(PacketBufferBC buffer) throws IOException {
        if (buffer.readBoolean()) {
            Item item = Item.func_150899_d((int)buffer.readUnsignedShort());
            short meta = buffer.readShort();
            ItemStack stack = new ItemStack(item, 1, (int)meta);
            stack.func_77982_d(buffer.func_150793_b());
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected String getCacheName() {
        return "ItemStack";
    }
}

