/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.tile.item;

import buildcraft.api.inventory.IItemHandlerFiltered;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerFiltered
extends ItemHandlerSimple
implements IItemHandlerFiltered {
    private final IItemHandler filter;
    private final boolean emptyIsAnything;

    public ItemHandlerFiltered(IItemHandler filter, boolean emptyIsAnything) {
        super(filter.getSlots());
        this.emptyIsAnything = emptyIsAnything;
        this.filter = filter;
        this.setChecker((slot, stack) -> {
            ItemStack inSlot = filter.getStackInSlot(slot);
            if (inSlot.func_190926_b()) {
                return emptyIsAnything;
            }
            return StackUtil.canMerge(stack, inSlot);
        });
    }

    @Override
    public int getSlotLimit(int slot) {
        if (this.emptyIsAnything || !this.getFilter(slot).func_190926_b()) {
            return super.getSlotLimit(slot);
        }
        return 0;
    }

    @Override
    public ItemStack getFilter(int slot) {
        ItemStack current = this.getStackInSlot(slot);
        if (!current.func_190926_b()) {
            return current;
        }
        return this.filter.getStackInSlot(slot);
    }
}

