/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.client.gui;

import java.io.IOException;
import net.chococraft.client.gui.GuiButtonTextured;
import net.chococraft.common.ChocoConfig;
import net.chococraft.common.entities.EntityChocobo;
import net.chococraft.common.entities.properties.ChocoboAttributes;
import net.chococraft.common.handler.ExperienceHandler;
import net.chococraft.common.network.PacketManager;
import net.chococraft.common.network.packets.PacketUpgradeChocobo;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiChocoboInfo
extends GuiScreen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("chococraft", "textures/gui/chocobo_stats.png");
    private final EntityChocobo chocobo;
    private final EntityPlayer player;
    private int xSize = 176;
    private int ySize = 89;
    private int guiLeft;
    private int guiTop;

    public GuiChocoboInfo(EntityChocobo chocobo, EntityPlayer player) {
        this.chocobo = chocobo;
        this.player = player;
    }

    public void func_73866_w_() {
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.add(new GuiButtonTextured(0, 24, 52, 20, 20, TEXTURE, 0, 105, 16, 16));
        this.field_146292_n.add(new GuiButtonTextured(1, 60, 52, 20, 20, TEXTURE, 16, 105, 16, 16));
        this.field_146292_n.add(new GuiButtonTextured(2, 96, 52, 20, 20, TEXTURE, 32, 105, 16, 16));
        this.field_146292_n.add(new GuiButtonTextured(3, 132, 52, 20, 20, TEXTURE, 48, 105, 16, 16));
    }

    protected void func_146284_a(GuiButton b) {
        PacketUpgradeChocobo packet = new PacketUpgradeChocobo(this.chocobo, b.field_146127_k + 1);
        PacketManager.INSTANCE.sendToServer((IMessage)packet);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        mouseX -= this.guiLeft;
        mouseY -= this.guiTop;
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.func_73729_b(0, 0, 0, 0, this.xSize, this.ySize);
        String name = this.chocobo.func_145748_c_().func_150260_c();
        int nameLength = this.field_146289_q.func_78256_a(name);
        this.field_146289_q.func_175063_a(name, (float)(this.xSize / 2 - nameLength / 2), 4.0f, -1);
        String ownerText = I18n.func_135052_a((String)"gui.chocoinfo.text.not_tamed", (Object[])new Object[0]);
        if (this.chocobo.func_70909_n()) {
            EntityLivingBase owner = this.chocobo.func_70902_q();
            ownerText = owner == null ? I18n.func_135052_a((String)"gui.chocoinfo.text.unknown_owner", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.chocoinfo.text.owner_format", (Object[])new Object[]{owner.func_145748_c_().func_150260_c()});
        }
        int ownerTextLength = this.field_146289_q.func_78256_a(ownerText);
        this.field_146289_q.func_175063_a(ownerText, (float)(this.xSize / 2 - ownerTextLength / 2), 74.0f, -1);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.drawGenderInfo();
        this.drawHealthInfo();
        this.drawSpeedInfo();
        this.drawStaminaInfo();
        this.updateButtonTextures();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.interceptButtons();
        this.drawHover(mouseX, mouseY);
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX -= this.guiLeft, mouseY -= this.guiTop, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX -= this.guiLeft, mouseY -= this.guiTop, state);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX -= this.guiLeft, mouseY -= this.guiTop, clickedMouseButton, timeSinceLastClick);
    }

    private void updateButtonTextures() {
        for (GuiButton btn : this.field_146292_n) {
            GuiButtonTextured btnt = (GuiButtonTextured)btn;
            btnt.setTexture(TEXTURE, btnt.field_146127_k * 16, this.canUseAbility(btn.field_146127_k) ? 89 : 105, 16, 16);
        }
    }

    private void interceptButtons() {
        for (GuiButton btn : this.field_146292_n) {
            int width;
            String tooltip;
            boolean bl = btn.field_146124_l = this.getAbilityXPCost(btn.field_146127_k) <= ExperienceHandler.getExperience(this.player) && !this.canUseAbility(btn.field_146127_k);
            if (!btn.func_146115_a()) continue;
            if (this.canUseAbility(btn.field_146127_k)) {
                tooltip = I18n.func_135052_a((String)"gui.chocoinfo.button.already_unlocked_ability", (Object[])new Object[]{I18n.func_135052_a((String)this.getAbilityFromButton(btn.field_146127_k), (Object[])new Object[0])});
                width = this.field_146289_q.func_78256_a(tooltip);
                this.field_146289_q.func_175065_a(tooltip, (float)(88 - width / 2), 93.0f, -1, true);
                continue;
            }
            tooltip = I18n.func_135052_a((String)"gui.chocoinfo.button.ability", (Object[])new Object[]{ExperienceHandler.getExperience(this.player), this.getAbilityXPCost(btn.field_146127_k), I18n.func_135052_a((String)this.getAbilityFromButton(btn.field_146127_k), (Object[])new Object[0])});
            width = this.field_146289_q.func_78256_a(tooltip);
            this.field_146289_q.func_175065_a(tooltip, (float)(88 - width / 2), 93.0f, -1, true);
        }
    }

    private void drawGenderInfo() {
        this.func_73729_b(26, 18, 176, this.chocobo.isMale() ? 16 : 0, 16, 16);
        String value = I18n.func_135052_a((String)(this.chocobo.isMale() ? "gui.chocoinfo.texture.male" : "gui.chocoinfo.texture.female"), (Object[])new Object[0]);
        int width = this.field_146289_q.func_78256_a(value);
        this.field_146289_q.func_175063_a(value, (float)(35 - width / 2), 36.0f, -1);
    }

    private void drawHealthInfo() {
        String value = String.valueOf((int)this.chocobo.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
        int width = this.field_146289_q.func_78256_a(value);
        this.field_146289_q.func_175063_a(value, (float)(70 - width / 2), 36.0f, -1);
    }

    private void drawSpeedInfo() {
        String value = String.valueOf((int)Math.round(this.chocobo.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * 100.0));
        int width = this.field_146289_q.func_78256_a(value);
        this.field_146289_q.func_175063_a(value, (float)(106 - width / 2), 36.0f, -1);
    }

    private void drawStaminaInfo() {
        String value = String.valueOf((int)this.chocobo.func_110148_a(ChocoboAttributes.MAX_STAMINA).func_111125_b());
        int width = this.field_146289_q.func_78256_a(value);
        this.field_146289_q.func_175063_a(value, (float)(142 - width / 2), 36.0f, -1);
    }

    private void drawHover(int mouseX, int mouseY) {
        if (mouseX >= 25 && mouseY >= 17 && mouseX < 43 && mouseY < 35) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.chocoinfo.texture.gender", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (mouseX >= 61 && mouseY >= 17 && mouseX < 79 && mouseY < 35) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.chocoinfo.texture.health", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (mouseX >= 97 && mouseY >= 17 && mouseX < 115 && mouseY < 35) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.chocoinfo.texture.speed", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (mouseX >= 133 && mouseY >= 17 && mouseX < 151 && mouseY < 35) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.chocoinfo.texture.stamina", (Object[])new Object[0]), mouseX, mouseY);
        }
        for (GuiButton btn : this.field_146292_n) {
            if (!btn.func_146115_a()) continue;
            this.func_146279_a(I18n.func_135052_a((String)"gui.chocoinfo.button.button_format", (Object[])new Object[]{I18n.func_135052_a((String)this.getAbilityFromButton(btn.field_146127_k), (Object[])new Object[0])}), mouseX, mouseY);
        }
    }

    private boolean canUseAbility(int i) {
        switch (i) {
            case 0: {
                return this.chocobo.canSprint();
            }
            case 1: {
                return this.chocobo.canGlide();
            }
            case 2: {
                return this.chocobo.canDive();
            }
            case 3: {
                return this.chocobo.canFly();
            }
        }
        return false;
    }

    private String getAbilityFromButton(int i) {
        String key = "gui.chocoinfo.button.";
        switch (i) {
            case 0: {
                return key + "sprint";
            }
            case 1: {
                return key + "glide";
            }
            case 2: {
                return key + "dive";
            }
            case 3: {
                return key + "fly";
            }
        }
        return key + "";
    }

    private int getAbilityXPCost(int i) {
        switch (i) {
            case 0: {
                return ChocoConfig.chocobo.ExpCostSprint;
            }
            case 1: {
                return ChocoConfig.chocobo.ExpCostGlide;
            }
            case 2: {
                return ChocoConfig.chocobo.ExpCostDive;
            }
            case 3: {
                return ChocoConfig.chocobo.ExpCostFly;
            }
        }
        return 0;
    }
}

