/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.common.entities.breeding;

import net.chococraft.common.ChocoConfig;
import net.chococraft.common.entities.EntityChocobo;
import net.chococraft.common.entities.properties.ChocoboAttributes;
import net.chococraft.common.entities.properties.ChocoboColor;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;

public class ChocoboStatSnapshot {
    public static final ChocoboStatSnapshot DEFAULT = new ChocoboStatSnapshot();
    public static final String NBTKEY_GENERATION = "Generation";
    public static final String NBTKEY_HEALTH = "Health";
    public static final String NBTKEY_SPEED = "Speed";
    public static final String NBTKEY_STAMINA = "Stamina";
    public static final String NBTKEY_CAN_SPRINT = "CanSprint";
    public static final String NBTKEY_CAN_GLIDE = "CanGlide";
    public static final String NBTKEY_CAN_DIVE = "CanDive";
    public static final String NBTKEY_CAN_FLY = "CanFly";
    public static final String NBTKEY_COLOR = "Color";
    public int generation;
    public float health;
    public float speed;
    public float stamina;
    public boolean canSprint;
    public boolean canGlide;
    public boolean canDive;
    public boolean canFly;
    public ChocoboColor color;

    private ChocoboStatSnapshot() {
    }

    public ChocoboStatSnapshot(EntityChocobo chocobo) {
        this.generation = chocobo.getGeneration();
        this.health = (float)chocobo.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
        this.speed = (float)chocobo.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b();
        this.stamina = (float)chocobo.func_110148_a(ChocoboAttributes.MAX_STAMINA).func_111125_b();
        this.canSprint = chocobo.canSprint();
        this.canGlide = chocobo.canGlide();
        this.canDive = chocobo.canDive();
        this.canFly = chocobo.canFly();
        this.color = chocobo.getChocoboColor();
    }

    public ChocoboStatSnapshot(NBTTagCompound nbt) {
        this.generation = nbt.func_74762_e(NBTKEY_GENERATION);
        this.health = nbt.func_74760_g(NBTKEY_HEALTH);
        this.speed = nbt.func_74760_g(NBTKEY_SPEED);
        this.stamina = nbt.func_74760_g(NBTKEY_STAMINA);
        this.canSprint = nbt.func_74767_n(NBTKEY_CAN_SPRINT);
        this.canGlide = nbt.func_74767_n(NBTKEY_CAN_GLIDE);
        this.canDive = nbt.func_74767_n(NBTKEY_CAN_DIVE);
        this.canFly = nbt.func_74767_n(NBTKEY_CAN_FLY);
        this.color = ChocoboColor.values()[nbt.func_74771_c(NBTKEY_COLOR)];
    }

    public NBTTagCompound serialize() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a(NBTKEY_GENERATION, this.generation);
        nbt.func_74776_a(NBTKEY_HEALTH, this.health);
        nbt.func_74776_a(NBTKEY_SPEED, this.speed);
        nbt.func_74776_a(NBTKEY_STAMINA, this.stamina);
        nbt.func_74757_a(NBTKEY_CAN_FLY, this.canFly);
        nbt.func_74757_a(NBTKEY_CAN_GLIDE, this.canGlide);
        nbt.func_74757_a(NBTKEY_CAN_SPRINT, this.canSprint);
        nbt.func_74757_a(NBTKEY_CAN_DIVE, this.canDive);
        nbt.func_74774_a(NBTKEY_COLOR, (byte)this.color.ordinal());
        return nbt;
    }

    static {
        ChocoboStatSnapshot.DEFAULT.generation = 1;
        ChocoboStatSnapshot.DEFAULT.health = ChocoConfig.chocobo.defaultHealth;
        ChocoboStatSnapshot.DEFAULT.stamina = ChocoConfig.chocobo.defaultStamina;
        ChocoboStatSnapshot.DEFAULT.speed = (float)ChocoConfig.chocobo.defaultSpeed / 100.0f;
        ChocoboStatSnapshot.DEFAULT.canSprint = false;
        ChocoboStatSnapshot.DEFAULT.canGlide = false;
        ChocoboStatSnapshot.DEFAULT.canDive = false;
        ChocoboStatSnapshot.DEFAULT.canFly = false;
        ChocoboStatSnapshot.DEFAULT.color = ChocoboColor.YELLOW;
    }
}

