/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template.component;

import com.google.gson.annotations.SerializedName;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import vazkii.patchouli.api.VariableHolder;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.page.PageEntity;
import vazkii.patchouli.client.book.template.TemplateComponent;
import vazkii.patchouli.common.util.EntityUtil;

public class ComponentEntity
extends TemplateComponent {
    @VariableHolder
    @SerializedName(value="entity")
    public String entityId;
    @SerializedName(value="render_size")
    float renderSize = 100.0f;
    boolean rotate = true;
    @SerializedName(value="default_rotation")
    float defaultRotation = -45.0f;
    transient boolean errored;
    transient Entity entity;
    transient EntityUtil.EntityCreator creator;
    transient float renderScale;
    transient float offset;

    @Override
    public void build(BookPage page, BookEntry entry, int pageNum) {
        this.creator = EntityUtil.loadEntity(this.entityId);
    }

    @Override
    public void onDisplayed(BookPage page, GuiBookEntry parent, int left, int top) {
        this.loadEntity((World)page.mc.field_71441_e);
    }

    @Override
    public void render(BookPage page, int mouseX, int mouseY, float pticks) {
        if (this.errored) {
            page.fontRenderer.func_175063_a(I18n.func_135052_a((String)"patchouli.gui.lexicon.loading_error", (Object[])new Object[0]), (float)this.x, (float)this.y, 0xFF0000);
        }
        if (this.entity != null) {
            this.renderEntity((World)page.mc.field_71441_e, this.rotate ? ClientTicker.total : this.defaultRotation);
        }
    }

    private void renderEntity(World world, float rotation) {
        PageEntity.renderEntity(this.entity, world, this.x, this.y, rotation, this.renderScale, this.offset);
    }

    private void loadEntity(World world) {
        if (!this.errored && (this.entity == null || this.entity.field_70128_L)) {
            try {
                this.entity = this.creator.create(world);
                float entitySize = this.entity.field_70130_N;
                if (this.entity.field_70130_N < this.entity.field_70131_O) {
                    entitySize = this.entity.field_70131_O;
                }
                entitySize = Math.max(1.0f, entitySize);
                this.renderScale = this.renderSize / entitySize * 0.8f;
                this.offset = Math.max(this.entity.field_70131_O, entitySize) * 0.5f;
            }
            catch (Exception e) {
                this.errored = true;
                e.printStackTrace();
            }
        }
    }
}

