/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreIngredient;

public class ItemStackUtil {
    public static String serializeStack(ItemStack stack) {
        StringBuilder builder = new StringBuilder();
        builder.append(stack.func_77973_b().getRegistryName().toString());
        builder.append(":");
        builder.append(stack.func_77952_i());
        int count = stack.func_190916_E();
        if (count > 1) {
            builder.append("#");
            builder.append(count);
        }
        if (stack.func_77942_o()) {
            builder.append(stack.func_77978_p().toString());
        }
        return builder.toString();
    }

    public static ItemStack loadStackFromString(String res) {
        String[] tokens;
        String nbt = "";
        int nbtStart = res.indexOf("{");
        if (nbtStart > 0) {
            nbt = res.substring(nbtStart).replaceAll("([^\\\\])'", "$1\"").replaceAll("\\\\'", "'");
            res = res.substring(0, nbtStart);
        }
        int meta = 0;
        String[] upper = res.split("#");
        String count = "1";
        if (upper.length > 1) {
            res = upper[0];
            count = upper[1];
        }
        if ((tokens = res.split(":")).length < 2) {
            return ItemStack.field_190927_a;
        }
        if (tokens.length == 3) {
            meta = Integer.parseInt(tokens[2]);
        }
        int countn = Integer.parseInt(count);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(tokens[0], tokens[1]));
        ItemStack stack = new ItemStack(item, countn, meta);
        if (!nbt.isEmpty()) {
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)nbt));
            }
            catch (NBTException e) {
                throw new RuntimeException("Failed to parse ItemStack JSON", e);
            }
        }
        return stack;
    }

    public static String serializeIngredient(Ingredient ingredient) {
        ItemStack[] stacks = ingredient.func_193365_a();
        CharSequence[] stacksSerialized = new String[stacks.length];
        for (int i = 0; i < stacks.length; ++i) {
            stacksSerialized[i] = ItemStackUtil.serializeStack(stacks[i]);
        }
        return String.join((CharSequence)",", stacksSerialized);
    }

    public static Ingredient loadIngredientFromString(String ingredientString) {
        String[] stacksSerialized = ItemStackUtil.splitStacksFromSerializedIngredient(ingredientString);
        ArrayList stacks = Lists.newArrayList();
        for (int i = 0; i < stacksSerialized.length; ++i) {
            if (stacksSerialized[i].startsWith("ore:")) {
                OreIngredient ore = new OreIngredient(stacksSerialized[i].substring(4));
                for (ItemStack stack : ore.func_193365_a()) {
                    stacks.add(stack);
                }
            }
            stacks.add(ItemStackUtil.loadStackFromString(stacksSerialized[i]));
        }
        return Ingredient.func_193369_a((ItemStack[])stacks.toArray(new ItemStack[stacks.size()]));
    }

    public static StackWrapper wrapStack(ItemStack stack) {
        return stack.func_190926_b() ? StackWrapper.EMPTY_WRAPPER : new StackWrapper(stack);
    }

    private static String[] splitStacksFromSerializedIngredient(String ingredientSerialized) {
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        int braces = 0;
        Character insideString = null;
        block7: for (int i = 0; i < ingredientSerialized.length(); ++i) {
            switch (ingredientSerialized.charAt(i)) {
                case '{': {
                    if (insideString != null) continue block7;
                    ++braces;
                    continue block7;
                }
                case '}': {
                    if (insideString != null) continue block7;
                    --braces;
                    continue block7;
                }
                case '\'': {
                    insideString = insideString == null ? Character.valueOf('\'') : null;
                    continue block7;
                }
                case '\"': {
                    insideString = insideString == null ? Character.valueOf('\"') : null;
                    continue block7;
                }
                case ',': {
                    if (braces > 0) continue block7;
                    result.add(ingredientSerialized.substring(lastIndex, i));
                    lastIndex = i + 1;
                }
            }
        }
        result.add(ingredientSerialized.substring(lastIndex));
        return result.toArray(new String[result.size()]);
    }

    public static class StackWrapper {
        public static final StackWrapper EMPTY_WRAPPER = new StackWrapper(ItemStack.field_190927_a);
        public final ItemStack stack;

        public StackWrapper(ItemStack stack) {
            this.stack = stack;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof StackWrapper && ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)((StackWrapper)obj).stack);
        }

        public int hashCode() {
            return this.stack.func_77973_b().hashCode() ^ this.stack.func_77952_i() * 31;
        }

        public String toString() {
            return "Wrapper[" + this.stack.toString() + "]";
        }
    }
}

