/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.classic.tile;

import com.google.common.base.Objects;
import ic2.api.info.ILocatable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public interface ITeleporterTarget
extends ILocatable {
    public TeleportType getSendingType();

    public boolean canReceiveType(TeleportType var1);

    public EnumFacing getTeleporterFacing();

    public void setTarget(TeleporterTarget var1);

    public boolean hasTarget(TeleporterTarget var1);

    public static class TeleporterTarget {
        private final BlockPos pos;
        private final int dim;
        private final int hashCode;
        public boolean isCustom = false;

        protected TeleporterTarget(TeleporterTarget target) {
            this.pos = target.pos;
            this.dim = target.dim;
            this.hashCode = target.hashCode;
        }

        public TeleporterTarget(NBTTagCompound nbt) {
            this(new BlockPos(nbt.func_74762_e("xPos"), nbt.func_74762_e("yPos"), nbt.func_74762_e("zPos")), nbt.func_74762_e("DimID"));
            this.isCustom = nbt.func_74767_n("IsCustom");
        }

        public TeleporterTarget(ITeleporterTarget target) {
            this(target.getPosition(), target.getWorldObj());
        }

        public TeleporterTarget(BlockPos pos, World world) {
            this(pos, world.field_73011_w.getDimension());
        }

        public TeleporterTarget(BlockPos pos, int id) {
            this.pos = pos;
            this.dim = id;
            this.hashCode = Objects.hashCode((Object[])new Object[]{pos, id});
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TeleporterTarget) {
                TeleporterTarget other = (TeleporterTarget)obj;
                return other.dim == this.dim && Objects.equal((Object)other.pos, (Object)this.pos);
            }
            return false;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("DimID", this.dim);
            nbt.func_74768_a("xPos", this.pos.func_177958_n());
            nbt.func_74768_a("yPos", this.pos.func_177956_o());
            nbt.func_74768_a("zPos", this.pos.func_177952_p());
            nbt.func_74757_a("IsCustom", this.isCustom);
            return nbt;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getDimID() {
            return this.dim;
        }

        public TileEntity getTile() {
            return this.getWorld().func_175625_s(this.pos);
        }

        public World getWorld() {
            return FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dim);
        }
    }

    public static final class TeleporterNameRegistry {
        private static final Map<TeleporterTarget, String> nameRegistry = new LinkedHashMap<TeleporterTarget, String>();

        public static void addTeleporter(TeleporterTarget target, String targetName) {
            nameRegistry.put(target, targetName);
        }

        public static String getName(TeleporterTarget target) {
            return nameRegistry.get(target);
        }

        public static void removeTeleporter(TeleporterTarget target) {
            nameRegistry.remove(target);
        }

        public static Map<TeleporterTarget, String> getMap() {
            return nameRegistry;
        }
    }

    public static enum TeleportType {
        Item,
        Fluid,
        Energy,
        Entity,
        None;

    }
}

