/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.tile;

import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.INullableRecipeInput;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IRecipeMachine;
import ic2.api.classic.tile.IStackOutput;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.energy.EnergyNet;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.audio.AudioSource;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.EnergyUsageInfo;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.base.util.info.misc.IEnergyUser;
import ic2.core.block.base.util.output.IStackRegistry;
import ic2.core.block.base.util.output.SimpleStackOutput;
import ic2.core.block.machine.low.container.ContainerBasicElectricMachine;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.wrapper.RangedInventoryWrapper;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IOutputMachine;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileEntityBasicElectricMachine
extends TileEntityElecMachine
implements ITickable,
IProgressMachine,
IRecipeMachine,
IOutputMachine,
IHasGui,
INetworkTileEntityEventListener,
IEnergyUser {
    @NetworkField(index=7)
    public float progress = 0.0f;
    public int defaultEnergyConsume;
    public int defaultOperationLength;
    public int defaultMaxInput;
    public int defaultEnergyStorage;
    public int energyConsume;
    public int operationLength;
    public float progressPerTick;
    @NetworkField(index=8)
    public float soundLevel = 1.0f;
    public IMachineRecipeList.RecipeEntry lastRecipe;
    public IMachineRecipeList.RecipeEntry activeRecipe;
    @NetworkField(index=9)
    public int recipeOperation;
    @NetworkField(index=10)
    public int recipeEnergy;
    @NetworkField(index=11)
    public boolean redstoneInverted;
    @NetworkField(index=12)
    public boolean redstoneSensitive;
    public boolean defaultSensitive;
    public LinkedList<IStackOutput> results = new LinkedList();
    public AudioSource audioSource;
    public IFilter filter;
    public boolean checkRecipe = true;

    public TileEntityBasicElectricMachine(int slots, int energyPerTick, int maxProgress, int maxinput) {
        super(slots + 4, maxinput);
        this.setFuelSlot(1);
        this.energyConsume = energyPerTick;
        this.defaultEnergyConsume = energyPerTick;
        this.operationLength = maxProgress;
        this.defaultOperationLength = maxProgress;
        this.defaultMaxInput = this.maxInput;
        this.defaultEnergyStorage = energyPerTick * maxProgress;
        this.defaultSensitive = false;
        this.addNetworkFields("soundLevel", "redstoneInverted", "redstoneSensitive");
        this.addGuiFields("recipeOperation", "recipeEnergy", "progress");
        this.addInfos(new EnergyUsageInfo(this), new ProgressInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        this.filter = new MachineFilter(this);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Import, 0);
        handler.registerDefaultSlotAccess(AccessRule.Export, 2);
        handler.registerDefaultSlotAccess(AccessRule.Both, 1);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 1);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), 0);
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), 2);
        handler.registerInputFilter(new ArrayFilter(CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)), 1);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 1);
        handler.registerInputFilter(this.filter, 0);
        handler.registerSlotType(SlotType.Input, 0);
        handler.registerSlotType(SlotType.Discharge, 1);
        handler.registerSlotType(SlotType.Output, 2);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
    }

    @Override
    public int getEnergyUsage() {
        return this.recipeEnergy;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public float getMaxProgress() {
        return this.recipeOperation;
    }

    public abstract IMachineRecipeList.RecipeEntry getOutputFor(ItemStack var1);

    public abstract ResourceLocation getGuiTexture();

    public boolean canWorkWithoutItems() {
        return false;
    }

    public ResourceLocation getStartSoundFile() {
        return null;
    }

    public ResourceLocation getInterruptSoundFile() {
        return null;
    }

    public void operateOnce(IRecipeInput input, MachineOutput output, List<IStackOutput> list) {
        for (ItemStack stack : output.getRecipeOutput(this.func_145831_w().field_73012_v, this.getTileData())) {
            list.add(new SimpleStackOutput(stack, 2));
        }
        this.consumeInput(input, output.getMetadata());
    }

    public void consumeInput(IRecipeInput input, NBTTagCompound recipeData) {
        if (input instanceof INullableRecipeInput && ((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return;
        }
        if (((ItemStack)this.inventory.get(0)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(0)) && (recipeData == null || !recipeData.func_74767_n("consume_containers"))) {
            this.inventory.set(0, (Object)((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)));
        } else {
            ((ItemStack)this.inventory.get(0)).func_190918_g(input.getAmount());
        }
    }

    @Override
    public boolean supportsNotify() {
        return true;
    }

    @Override
    public boolean needsInitialRedstoneUpdate() {
        return true;
    }

    public void func_73660_a() {
        boolean operate;
        IMachineRecipeList.RecipeEntry entry;
        this.handleRedstone();
        this.updateNeighbors();
        boolean noRoom = this.addToInventory();
        this.activeRecipe = entry = this.getRecipe();
        boolean canWork = this.canWork() && !noRoom;
        boolean bl = operate = canWork && entry != null;
        if (operate) {
            this.handleChargeSlot(this.maxEnergy);
        }
        if (operate && this.energy >= this.energyConsume) {
            if (!this.getActive()) {
                this.getNetwork().initiateTileEntityEvent(this, 0, false);
            }
            this.setActive(true);
            this.progress += this.progressPerTick;
            this.useEnergy(this.recipeEnergy);
            if (this.progress >= (float)this.recipeOperation) {
                this.operate(entry);
                this.progress = 0.0f;
                this.notifyNeighbors();
                this.checkRecipe = true;
            }
            this.getNetwork().updateTileGuiField(this, "progress");
        } else {
            if (this.getActive()) {
                if (this.progress != 0.0f) {
                    this.getNetwork().initiateTileEntityEvent(this, 1, false);
                } else {
                    this.getNetwork().initiateTileEntityEvent(this, 2, false);
                }
            }
            this.progress = this.updateInactiveProgress(entry, this.progress);
            this.setActive(false);
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            ((IMachineUpgradeItem)item.func_77973_b()).onTick(item, this);
        }
        this.updateComparators();
    }

    public void handleModifiers(IMachineRecipeList.RecipeEntry entry) {
        if (entry == null || entry.getOutput().getMetadata() == null) {
            if (this.recipeEnergy != this.energyConsume) {
                this.recipeEnergy = this.energyConsume;
                if (this.recipeEnergy < 1) {
                    this.recipeEnergy = 1;
                }
                this.getNetwork().updateTileGuiField(this, "recipeEnergy");
            }
            if (this.recipeOperation != this.operationLength) {
                this.recipeOperation = this.operationLength;
                if (this.recipeOperation < 1) {
                    this.recipeOperation = 1;
                }
                this.getNetwork().updateTileGuiField(this, "recipeOperation");
            }
            return;
        }
        NBTTagCompound nbt = entry.getOutput().getMetadata();
        double energyMod = nbt.func_74764_b("RecipeEnergyModifier") ? nbt.func_74769_h("RecipeEnergyModifier") : 1.0;
        int newEnergy = TileEntityBasicElectricMachine.applyModifier(this.energyConsume, nbt.func_74762_e("RecipeEnergy"), energyMod);
        if (newEnergy != this.recipeEnergy) {
            this.recipeEnergy = newEnergy;
            if (this.recipeEnergy < 1) {
                this.recipeEnergy = 1;
            }
            this.getNetwork().updateTileGuiField(this, "recipeEnergy");
        }
        double progMod = nbt.func_74764_b("RecipeTimeModifier") ? nbt.func_74769_h("RecipeTimeModifier") : 1.0;
        int newProgress = TileEntityBasicElectricMachine.applyModifier(this.operationLength, nbt.func_74762_e("RecipeTime"), progMod);
        if (newProgress != this.recipeOperation) {
            this.recipeOperation = newProgress;
            if (this.recipeOperation < 1) {
                this.recipeOperation = 1;
            }
            this.getNetwork().updateTileGuiField(this, "recipeOperation");
        }
    }

    public float updateInactiveProgress(IMachineRecipeList.RecipeEntry entry, float currentProgress) {
        if (entry == null && currentProgress != 0.0f) {
            this.getNetwork().updateTileGuiField(this, "progress");
            return 0.0f;
        }
        return currentProgress;
    }

    public void operate(IMachineRecipeList.RecipeEntry entry) {
        IRecipeInput input = entry.getInput();
        MachineOutput output = entry.getOutput().copy();
        for (int i = 0; i < 4; ++i) {
            ItemStack itemStack = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
            if (!(itemStack.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem item = (IMachineUpgradeItem)itemStack.func_77973_b();
            item.onProcessEndPre(itemStack, this, output);
        }
        ArrayList<IStackOutput> list = new ArrayList<IStackOutput>();
        this.operateOnce(input, output, list);
        for (int i = 0; i < 4; ++i) {
            ItemStack itemStack = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
            if (!(itemStack.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem item = (IMachineUpgradeItem)itemStack.func_77973_b();
            item.onProcessEndPost(itemStack, this, input, output, list);
        }
        if (list.size() > 0) {
            this.results.addAll(list);
            this.addToInventory();
        }
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        if (this.isSimulating()) {
            this.checkRecipe = true;
        }
    }

    public boolean addToInventory() {
        if (this.results.isEmpty()) {
            return false;
        }
        Iterator iter = this.results.iterator();
        while (iter.hasNext()) {
            IStackOutput output = (IStackOutput)iter.next();
            if (!output.addToInventory(this)) continue;
            iter.remove();
        }
        return this.results.size() > 0;
    }

    private IMachineRecipeList.RecipeEntry getRecipe() {
        if (!this.checkRecipe) {
            return this.activeRecipe;
        }
        this.checkRecipe = false;
        if (((ItemStack)this.inventory.get(0)).func_190926_b() && !this.canWorkWithoutItems()) {
            this.lastRecipe = null;
            return null;
        }
        if (this.lastRecipe != null) {
            IRecipeInput recipe = this.lastRecipe.getInput();
            if (recipe instanceof INullableRecipeInput) {
                if (!recipe.matches((ItemStack)this.inventory.get(0))) {
                    this.lastRecipe = null;
                }
            } else if (((ItemStack)this.inventory.get(0)).func_190926_b() || !recipe.matches((ItemStack)this.inventory.get(0))) {
                this.lastRecipe = null;
            } else {
                if (recipe.getAmount() > ((ItemStack)this.inventory.get(0)).func_190916_E()) {
                    return null;
                }
                EnumActionResult result = this.isRecipeStillValid(this.lastRecipe);
                if (result == EnumActionResult.FAIL) {
                    this.lastRecipe = null;
                } else if (result == EnumActionResult.PASS) {
                    return null;
                }
            }
        }
        if (this.lastRecipe == null) {
            IMachineRecipeList.RecipeEntry out = this.getOutputFor(((ItemStack)this.inventory.get(0)).func_77946_l());
            if (out == null) {
                return null;
            }
            this.lastRecipe = out;
            this.handleModifiers(out);
        }
        if (this.lastRecipe == null) {
            return null;
        }
        EnumActionResult result = this.canFillRecipeIntoOutputs(this.lastRecipe.getOutput());
        if (result == EnumActionResult.SUCCESS) {
            return this.lastRecipe;
        }
        if (result == EnumActionResult.PASS) {
            return null;
        }
        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
            return this.lastRecipe;
        }
        if (((ItemStack)this.inventory.get(2)).func_190916_E() >= ((ItemStack)this.inventory.get(2)).func_77976_d()) {
            return null;
        }
        for (ItemStack output : this.lastRecipe.getOutput().getAllOutputs()) {
            if (!StackUtil.isStackEqual((ItemStack)this.inventory.get(2), output, false, true)) continue;
            return this.lastRecipe;
        }
        return null;
    }

    protected EnumActionResult canFillRecipeIntoOutputs(MachineOutput output) {
        return EnumActionResult.FAIL;
    }

    protected EnumActionResult isRecipeStillValid(IMachineRecipeList.RecipeEntry entry) {
        return EnumActionResult.SUCCESS;
    }

    public boolean canWork() {
        if (!this.redstoneSensitive) {
            return true;
        }
        return this.isRedstonePowered();
    }

    @Override
    public boolean isRedstonePowered() {
        if (this.redstoneInverted) {
            return !super.isRedstonePowered();
        }
        return super.isRedstonePowered();
    }

    @Override
    public void handleRedstone() {
        if (this.redstoneSensitive) {
            super.handleRedstone();
        }
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount, boolean simulate) {
        if ((double)this.energy < amount) {
            return false;
        }
        if (!simulate) {
            this.useEnergy((int)amount);
        }
        return true;
    }

    @Override
    public void setRedstoneSensitive(boolean active) {
        if (this.redstoneSensitive != active) {
            this.redstoneSensitive = active;
        }
    }

    @Override
    public boolean isRedstoneSensitive() {
        return this.redstoneSensitive;
    }

    @Override
    public World getMachineWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getMachinePos() {
        return this.func_174877_v();
    }

    @Override
    public boolean isProcessing() {
        return this.getActive();
    }

    public float getRecipeProgress() {
        float ret = this.progress / (float)this.recipeOperation;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return true;
        }
        return StackUtil.isStackEqual((ItemStack)this.inventory.get(0), par1, false, true);
    }

    @Override
    public IHasInventory getOutputInventory() {
        return new RangedInventoryWrapper(this, 2);
    }

    @Override
    public IHasInventory getInputInventory() {
        return new RangedInventoryWrapper(this, 0).setFilters(this.filter);
    }

    @Override
    public Set<IMachineUpgradeItem.UpgradeType> getSupportedTypes() {
        return new ObjectLinkedOpenHashSet(Arrays.asList(IMachineUpgradeItem.UpgradeType.values()));
    }

    public void setOverclockRates() {
        this.lastRecipe = null;
        int extraProcessSpeed = 0;
        double processingSpeedMultiplier = 1.0;
        int extraProcessTime = 0;
        double processTimeMultiplier = 1.0;
        int extraEnergyDemand = 0;
        double energyDemandMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        float soundModfier = 1.0f;
        boolean redstonePowered = false;
        this.redstoneSensitive = this.defaultSensitive;
        for (int i = 0; i < 4; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem upgrade = (IMachineUpgradeItem)item.func_77973_b();
            upgrade.onInstalling(item, this);
            extraProcessSpeed += upgrade.getExtraProcessSpeed(item, this) * item.func_190916_E();
            processingSpeedMultiplier *= Math.pow(upgrade.getProcessSpeedMultiplier(item, this), item.func_190916_E());
            extraProcessTime += upgrade.getExtraProcessTime(item, this) * item.func_190916_E();
            processTimeMultiplier *= Math.pow(upgrade.getProcessTimeMultiplier(item, this), item.func_190916_E());
            extraEnergyDemand += upgrade.getExtraEnergyDemand(item, this) * item.func_190916_E();
            energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(item, this), item.func_190916_E());
            extraEnergyStorage += upgrade.getExtraEnergyStorage(item, this) * item.func_190916_E();
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(item, this), item.func_190916_E());
            soundModfier = (float)((double)soundModfier * Math.pow(upgrade.getSoundVolumeMultiplier(item, this), item.func_190916_E()));
            extraTier += upgrade.getExtraTier(item, this) * item.func_190916_E();
            if (!upgrade.useRedstoneInverter(item, this)) continue;
            redstonePowered = true;
        }
        this.redstoneInverted = redstonePowered;
        this.progressPerTick = TileEntityBasicElectricMachine.applyFloatModifier(1, extraProcessSpeed, processingSpeedMultiplier);
        this.energyConsume = TileEntityBasicElectricMachine.applyModifier(this.defaultEnergyConsume, extraEnergyDemand, energyDemandMultiplier);
        this.operationLength = TileEntityBasicElectricMachine.applyModifier(this.defaultOperationLength, extraProcessTime, processTimeMultiplier);
        this.setMaxEnergy(TileEntityBasicElectricMachine.applyModifier(this.defaultEnergyStorage, extraEnergyStorage, energyStorageMultiplier));
        this.tier = this.baseTier + extraTier;
        if (this.tier > 13) {
            this.tier = 13;
        }
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        if (this.energy > this.maxEnergy) {
            this.energy = this.maxEnergy;
        }
        this.soundLevel = soundModfier;
        if (this.progressPerTick < 0.01f) {
            this.progressPerTick = 0.01f;
        }
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        if (this.energyConsume < 1) {
            this.energyConsume = 1;
        }
        this.handleModifiers(this.lastRecipe);
        this.getNetwork().updateTileEntityField(this, "redstoneInverted");
        this.getNetwork().updateTileEntityField(this, "redstoneSensitive");
        this.getNetwork().updateTileEntityField(this, "soundLevel");
        this.getNetwork().updateTileGuiField(this, "maxInput");
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        long ret = Math.round((double)(base + extra) * multiplier);
        return ret > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ret;
    }

    public static float applyFloatModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483648E9 ? 2.1474836E9f : (float)ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.setOverclockRates();
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource.remove();
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    @Override
    public void onNetworkEvent(int event) {
        if (this.audioSource != null && this.audioSource.isRemoved()) {
            this.audioSource = null;
        }
        if (this.audioSource == null && this.getStartSoundFile() != null) {
            this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, this.getStartSoundFile(), true, false, IC2.audioManager.defaultVolume * this.soundLevel);
        }
        if (event == 0) {
            if (this.audioSource != null) {
                this.audioSource.play();
            }
        } else if (event == 1) {
            if (this.audioSource != null) {
                this.audioSource.stop();
                if (this.getInterruptSoundFile() != null) {
                    IC2.audioManager.playOnce(this, PositionSpec.Center, this.getInterruptSoundFile(), false, IC2.audioManager.defaultVolume * this.soundLevel);
                }
            }
        } else if (event == 2 && this.audioSource != null) {
            this.audioSource.stop();
        }
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("isActive") && this.getActive()) {
            this.onNetworkEvent(0);
        }
        super.onNetworkUpdate(field);
        if (field.equals("soundLevel") && this.audioSource != null) {
            this.audioSource.setVolume(IC2.audioManager.defaultVolume * this.soundLevel);
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerBasicElectricMachine(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74760_g("progress");
        this.results.clear();
        NBTTagList list = nbt.func_150295_c("Results", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            IStackOutput output = IStackRegistry.INSTANCE.readNBT(list.func_150305_b(i));
            if (output == null) continue;
            this.results.add(output);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("progress", this.progress);
        NBTTagList list = new NBTTagList();
        for (IStackOutput item : this.results) {
            list.func_74742_a((NBTBase)IStackRegistry.INSTANCE.saveNBT(item));
        }
        nbt.func_74782_a("Results", (NBTBase)list);
        return nbt;
    }
}

