/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.tile;

import ic2.api.classic.reactor.IChamberReactor;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorReactorChamber;
import ic2.core.block.base.util.info.ReactorChamberInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityReactorChamberBase
extends TileEntityBlock
implements IReactorChamber {
    public TileEntityReactorChamberBase() {
        this.addInfos(new ReactorChamberInfo(this));
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        manager.addComparatorMode(new ComparatorReactorChamber(this));
    }

    @Override
    public boolean isWall() {
        return false;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        TileEntity tile;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (tile = this.getReactorTile()) != null && tile.hasCapability(capability, facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        Object result;
        TileEntity tile;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (tile = this.getReactorTile()) != null && (result = tile.getCapability(capability, facing)) != null) {
            return (T)result;
        }
        return super.getCapability(capability, facing);
    }

    protected TileEntity getReactorTile() {
        IReactor reactor = this.getReactorInstance();
        if (reactor == null) {
            return null;
        }
        return reactor.getCoreTe();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        IReactor reactor = this.getReactorInstance();
        if (reactor instanceof IChamberReactor) {
            ((IChamberReactor)reactor).refreshChambers();
        }
    }

    @Override
    public void onUnloaded() {
        IReactor reactor = this.getReactorInstance();
        if (reactor instanceof IChamberReactor) {
            ((IChamberReactor)reactor).refreshChambers();
        }
        super.onUnloaded();
    }

    @Override
    public double getWrenchDropRate() {
        return 0.8;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return false;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }
}

