/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.info;

import ic2.api.classic.tile.IInfoTile;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.util.info.misc.IProbeComponent;
import ic2.core.item.tool.ItemToolWrench;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import java.awt.Color;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.Optional;

public class WrenchInfo
implements IProbeComponent {
    TileEntityBlock block;

    public WrenchInfo(TileEntityBlock tile) {
        this.block = tile;
    }

    @Override
    public String getDisplayText(EntityPlayer player) {
        if (this.block.canRemoveBlockProbe(player)) {
            int rate = MathHelper.func_76125_a((int)((int)(this.getWrenchLoss(player) * 100.0)), (int)0, (int)100);
            return Ic2InfoLang.lossChance.getLocalizedFormatted(rate + "%");
        }
        return "";
    }

    @Override
    public boolean canShow(EntityPlayer player) {
        return PlayerHandler.getClientPlayerHandler().hasWrench();
    }

    public double getWrenchLoss(EntityPlayer player) {
        double chance = this.block.getWrenchDropRate();
        ItemStack stack = player.func_184614_ca();
        if (stack == null) {
            stack = player.func_184592_cb();
        }
        if (stack != null && stack.func_77973_b() instanceof ItemToolWrench) {
            ItemToolWrench wrench = (ItemToolWrench)stack.func_77973_b();
            chance = wrench.canOverrideLossChance(stack) ? 1.0 : (chance *= wrench.applyFortune(stack, wrench.getModifier(stack)));
        }
        return chance;
    }

    @Override
    public IInfoTile.InfoType getType() {
        return IInfoTile.InfoType.Custom;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public boolean isModeValid(ProbeMode mode, PlayerHandler handler) {
        return mode != ProbeMode.NORMAL && handler.hasWrench();
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void applyInfo(IProbeInfo info, EntityPlayer player, EnumFacing side) {
        if (this.block.canRemoveBlockProbe(player)) {
            info.progress(MathHelper.func_76125_a((int)((int)(this.getWrenchLoss(player) * 100.0)), (int)0, (int)100), 100, info.defaultProgressStyle().filledColor(Color.RED.getRGB()).prefix("Drop Chance: "));
        }
    }
}

