/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.texture;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.api.classic.event.RetextureEventClassic;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.core.block.base.util.texture.ColorCopyEntry;
import ic2.core.block.base.util.texture.ICopyEntry;
import ic2.core.block.base.util.texture.TextureCopyEntry;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextureCopyStorage
implements INetworkFieldData {
    TextureCopyEntry[] entries;
    ColorCopyEntry[] colors;
    boolean[] texture;
    int entriesCount;

    public TextureCopyStorage(int size) {
        this.entriesCount = size;
        this.texture = new boolean[size];
        this.entries = TextureCopyEntry.createArray(size);
        this.colors = ColorCopyEntry.createArray(size);
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.texture = new boolean[this.entriesCount];
        this.entries = TextureCopyEntry.createArray(this.entriesCount);
        this.colors = ColorCopyEntry.createArray(this.entriesCount);
        for (int i = 0; i < this.entriesCount; ++i) {
            byte slot = buffer.readByte();
            this.texture[slot] = buffer.readBoolean();
            if (this.texture[slot]) {
                this.entries[slot].read(buffer);
                continue;
            }
            this.colors[slot].read(buffer);
        }
    }

    @Override
    public void write(IOutputBuffer buffer) {
        for (int i = 0; i < this.entriesCount; ++i) {
            buffer.writeByte((byte)i);
            buffer.writeBoolean(this.texture[i]);
            if (this.texture[i]) {
                this.entries[i].write(buffer);
                continue;
            }
            this.colors[i].write(buffer);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.entriesCount = nbt.func_74762_e("Count");
        this.texture = new boolean[this.entriesCount];
        this.entries = TextureCopyEntry.createArray(this.entriesCount);
        this.colors = ColorCopyEntry.createArray(this.entriesCount);
        NBTTagList list = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int slot = data.func_74762_e("Slot");
            if (slot < 0 || slot >= this.entriesCount) continue;
            this.texture[slot] = data.func_74767_n("Texture");
            if (this.texture[slot]) {
                this.entries[slot].readFromNBT(data);
                continue;
            }
            this.colors[i].readFromNBT(data);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Count", this.entriesCount);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.entriesCount; ++i) {
            NBTTagCompound data = new NBTTagCompound();
            if (this.texture[i]) {
                this.entries[i].writeFromNBT(data);
            } else {
                this.colors[i].writeToNBT(data);
            }
            data.func_74757_a("Texture", this.texture[i]);
            data.func_74774_a("Slot", (byte)i);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Data", (NBTBase)list);
    }

    public ICopyEntry getEntry(int entry) {
        return this.texture[entry] ? this.entries[entry] : this.colors[entry];
    }

    public boolean isColored(int entry) {
        return this.texture[entry];
    }

    public void set(int entry, IEnergyConductorColored.WireColor color) {
        if (this.texture[entry]) {
            this.texture[entry] = false;
            this.entries[entry].clear();
        }
        this.colors[entry].set(color);
    }

    public void setAll(IEnergyConductorColored.WireColor color) {
        for (int i = 0; i < this.entriesCount; ++i) {
            this.texture[i] = false;
            this.entries[i].clear();
            this.colors[i].set(color);
        }
    }

    public void setAll(IBlockState model, IBlockState render, int[] color, RetextureEventClassic.Rotation[] rot, EnumFacing facing) {
        for (int i = 0; i < this.entriesCount; ++i) {
            this.texture[i] = true;
            this.colors[i].clear();
            this.entries[i].set(model, render, color, rot, facing);
        }
    }

    public void set(int entry, IBlockState model, IBlockState render, int[] color, RetextureEventClassic.Rotation[] rot, EnumFacing facing) {
        if (!this.texture[entry]) {
            this.texture[entry] = true;
            this.colors[entry].clear();
        }
        this.entries[entry].set(model, render, color, rot, facing);
    }

    public IEnergyConductorColored.WireColor getColor(EnumFacing side) {
        return this.texture[side.func_176745_a()] ? IEnergyConductorColored.WireColor.Blank : this.colors[side.func_176745_a()].getColor();
    }

    public boolean canApply(IEnergyConductorColored.WireColor color) {
        for (int i = 0; i < 6; ++i) {
            if (this.texture[i]) {
                return true;
            }
            if (this.colors[i].getColor() == color) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public QuadList getQuads() {
        QuadList list = new QuadList();
        for (int i = 0; i < this.entriesCount; ++i) {
            list.addQuads(this.getEntry(i).getQuads());
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public static class QuadList {
        List<BakedQuad> quads = new LinkedList<BakedQuad>();

        public void addQuads(List<BakedQuad> list) {
            this.quads.addAll(list);
        }

        public List<BakedQuad> getQuads() {
            return this.quads;
        }
    }
}

